<?php
// Iniciar la sesión solo si no hay una activa. Esto es a prueba de errores.
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Si el usuario ya está logueado, lo saca de aquí.
if (isset($_SESSION['usuario_id'])) {
    header('Location: ' . BASE_URL . 'dashboard');
    exit;
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    global $conexion;

    $email = $_POST['email'] ?? '';
    $password = $_POST['contrasena'] ?? '';
    
    if ($email && $password) {
        $sql = "SELECT * FROM usuarios WHERE email = ? AND activo = 1 LIMIT 1";
        $stmt = $conexion->prepare($sql);
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();
        
        if ($user && password_verify($password, $user['password_hash'])) {
            // Ahora que la sesión está iniciada, esto funcionará.
            session_regenerate_id(true); 
            
            $_SESSION['usuario_id'] = $user['id'];
            $_SESSION['usuario_nombre'] = $user['nombre'];
            $_SESSION['usuario_rol'] = $user['rol'];
            $_SESSION['logged_in'] = true;

            // La redirección no debería dar error de "headers already sent".
            header('Location: ' . BASE_URL . 'dashboard');
            exit;
        } else {
            $error = 'Email o contraseña incorrectos';
        }
    } else {
        $error = 'Por favor, ingrese email y contraseña.';
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acceso de Administración</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo BASE_URL; ?>assets/css/estilos.css">
</head>
<body class="admin-login-body">

    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <h2><?php echo NOMBRE_SISTEMA; ?></h2>
                <p>Acceso para administradores.</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-danger" role="alert">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="mb-3">
                    <label for="email" class="form-label">Email</label>
                    <input type="email" class="form-control" id="email" name="email" required>
                </div>
                <div class="mb-4">
                    <label for="password" class="form-label">Contraseña</label>
                    <input type="password" class="form-control" id="password" name="contrasena" required>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-admin-primary w-100">Ingresar</button>
                </div>
            </form>
        </div>
    </div>

</body>
</html>
