<?php
function calcular_vencimiento($fecha_inicio, $dias_habiles = 10) {
    $fecha = new DateTime($fecha_inicio);
    $contador = 0;
    while ($contador < $dias_habiles) {
        $fecha->add(new DateInterval('P1D'));
        if (in_array($fecha->format('w'), [0, 6])) continue;
        $contador++;
    }
    return $fecha->format('Y-m-d H:i:s');
}

function dias_restantes($fecha_creacion, $plazo_dias = 10) {
    $vencimiento = calcular_vencimiento($fecha_creacion, $plazo_dias);
    return round((strtotime($vencimiento) - time()) / 86400);
}
?>