<?php
// Funciones compartidas del sistema - Versión Definitiva

function obtener_usuario_actual() {
    global $conn;
    if (!isset($_SESSION['usuario_id'])) {
        return null;
    }
    
    $usuario_id = $_SESSION['usuario_id'];
    $sql = "SELECT * FROM usuarios WHERE id = ? LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $usuario_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $usuario = $result->fetch_assoc();
    $stmt->close();
    
    return $usuario;
}

function obtener_empresa_actual() {
    global $conn;
    $usuario = obtener_usuario_actual();
    if (!$usuario || !$usuario['empresa_id']) {
        return null;
    }
    
    $empresa_id = $usuario['empresa_id'];
    $sql = "SELECT * FROM empresas WHERE id = ? LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $empresa_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $empresa = $result->fetch_assoc();
    $stmt->close();
    
    return $empresa;
}

function sanitizar_html($data) {
    return htmlspecialchars($data, ENT_QUOTES, 'UTF-8');
}

function formato_fecha($fecha, $formato = 'd/m/Y H:i') {
    if (!$fecha) return '-';
    $date = new DateTime($fecha);
    return $date->format($formato);
}
?>
