<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Test Mínimo</h1>";
echo "<p>✓ PHP funciona</p>";

echo "<h2>1. Verificando archivos...</h2>";

$archivos = [
    'config/configuracion.php',
    'config/conexion.php',
    'config/seguridad.php',
    'lib/funciones_comunes.php'
];

foreach ($archivos as $archivo) {
    if (file_exists($archivo)) {
        echo "✓ $archivo existe<br>";
        
        // Intentar incluir con manejo de errores
        echo "  Intentando cargar...<br>";
        
        define('COMITEH_APP', true);
        
        try {
            $content = file_get_contents($archivo);
            
            // Verificar si tiene BOM o caracteres raros al inicio
            if (substr($content, 0, 3) === "\xEF\xBB\xBF") {
                echo "  <span style='color:red'>✗ Archivo tiene BOM UTF-8</span><br>";
            }
            
            // Verificar si empieza correctamente
            if (substr(ltrim($content), 0, 5) !== "<?php") {
                echo "  <span style='color:red'>✗ Archivo NO empieza con &lt;?php</span><br>";
            } else {
                echo "  ✓ Archivo tiene formato correcto<br>";
            }
            
            // Contar líneas
            $lines = substr_count($content, "\n");
            echo "  ✓ $lines líneas<br>";
            
        } catch (Exception $e) {
            echo "  <span style='color:red'>✗ Error: " . $e->getMessage() . "</span><br>";
        }
        
    } else {
        echo "<span style='color:red'>✗ $archivo NO EXISTE</span><br>";
    }
    echo "<br>";
}

echo "<hr>";
echo "<h2>2. Intentando cargar config básico...</h2>";

if (!defined('COMITEH_APP')) {
    define('COMITEH_APP', true);
}

// Cargar configuracion.php
echo "Cargando configuracion.php...<br>";
try {
    include 'config/configuracion.php';
    echo "✓ Configuración cargada<br>";
    echo "✓ APP_NAME = " . (defined('APP_NAME') ? APP_NAME : 'NO DEFINIDO') . "<br>";
} catch (ParseError $e) {
    echo "<span style='color:red'>✗ ERROR DE SINTAXIS en configuracion.php:</span><br>";
    echo "<pre style='color:red'>" . $e->getMessage() . "</pre>";
    die();
} catch (Exception $e) {
    echo "<span style='color:red'>✗ ERROR: " . $e->getMessage() . "</span><br>";
    die();
}

// Cargar conexion.php
echo "<br>Cargando conexion.php...<br>";
try {
    include 'config/conexion.php';
    echo "✓ Conexión cargada<br>";
} catch (ParseError $e) {
    echo "<span style='color:red'>✗ ERROR DE SINTAXIS en conexion.php:</span><br>";
    echo "<pre style='color:red'>" . $e->getMessage() . "</pre>";
    die();
} catch (Exception $e) {
    echo "<span style='color:red'>✗ ERROR: " . $e->getMessage() . "</span><br>";
    die();
}

// Cargar seguridad.php
echo "<br>Cargando seguridad.php...<br>";
try {
    include 'config/seguridad.php';
    echo "✓ Seguridad cargada<br>";
} catch (ParseError $e) {
    echo "<span style='color:red'>✗ ERROR DE SINTAXIS en seguridad.php:</span><br>";
    echo "<pre style='color:red'>" . $e->getMessage() . "</pre>";
    die();
} catch (Exception $e) {
    echo "<span style='color:red'>✗ ERROR: " . $e->getMessage() . "</span><br>";
    die();
}

// Cargar funciones_comunes.php
echo "<br>Cargando funciones_comunes.php...<br>";
try {
    include 'lib/funciones_comunes.php';
    echo "✓ Funciones comunes cargada<br>";
} catch (ParseError $e) {
    echo "<span style='color:red'>✗ ERROR DE SINTAXIS en funciones_comunes.php:</span><br>";
    echo "<pre style='color:red'>" . $e->getMessage() . "</pre>";
    die();
} catch (Exception $e) {
    echo "<span style='color:red'>✗ ERROR: " . $e->getMessage() . "</span><br>";
    die();
}

echo "<hr>";
echo "<h2>✓ TODOS LOS ARCHIVOS CARGARON CORRECTAMENTE</h2>";
echo "<p>El sistema debería funcionar. Prueba <a href='index.php'>acceder aquí</a></p>";
?>
