<?php
/**
 * Portal Público - Seguimiento de Reclamos
 * Versión: 2.0 Definitiva
 */

define('COMITEH_APP', true);

require_once __DIR__ . '/../config/configuracion.php';
require_once __DIR__ . '/../config/conexion.php';
require_once __DIR__ . '/../lib/funciones_comunes.php';

$error = '';
$casos = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rut = limpiar_entrada($_POST['rut'] ?? '');
    $numero_caso = limpiar_entrada($_POST['numero_caso'] ?? '');
    
    if (empty($rut) || empty($numero_caso)) {
        $error = 'Debe ingresar RUT y Número de Caso';
    } elseif (!validar_rut($rut)) {
        $error = 'RUT no válido';
    } else {
        $query = "SELECT c.id, c.numero_caso, c.tipo_caso, c.asunto, c.estado, c.prioridad, c.descripcion, 
                  cl.nombre as cliente_nombre, e.nombre as empresa_nombre
                  FROM casos c
                  JOIN clientes cl ON c.cliente_id = cl.id
                  JOIN empresas e ON c.empresa_id = e.id
                  WHERE cl.rut = ? AND c.numero_caso = ?";
        
        $caso = obtener_fila($query, 'ss', [$rut, $numero_caso]);
        
        if (!$caso) {
            $error = 'No se encontraron casos con esos datos.';
        } else {
            // Obtener respuestas
            $query_respuestas = "SELECT r.*, u.nombre as usuario_nombre
                                 FROM respuestas r
                                 JOIN usuarios u ON r.usuario_id = u.id
                                 WHERE r.caso_id = ?
                                 ORDER BY r.fecha_respuesta DESC";
            $respuestas = obtener_filas($query_respuestas, 'i', [$caso['id']]);
        }
    }
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Seguimiento de Reclamos - <?php echo APP_NAME; ?></title>
    <style>
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background: #eef2f7; margin: 0; padding: 0; }
        .container { max-width: 700px; margin: 50px auto; padding: 20px; background: white; border-radius: 8px; }
        h1 { text-align: center; margin-bottom: 25px; }
        label { display: block; margin-bottom: 6px; font-weight: 600; }
        input[type=text] { width: 100%; padding: 10px 12px; margin-bottom: 15px; border: 1px solid #ccc; border-radius: 6px; font-size: 14px; }
        button { width: 100%; padding: 14px 0; font-size: 16px; border: none; border-radius: 6px; background: #667eea; color: white; cursor: pointer; font-weight: 700; }
        button:hover { background: #5568d3; }
        .alert { padding: 15px; border-radius: 6px; margin-bottom: 20px; font-size: 14px; }
        .alert-error { background: #fef2f2; color: #b91c1c; border: 1px solid #fca5a5; }
        .caso-info { background: #f8f9fa; padding: 20px; border-radius: 6px; margin-bottom: 30px; }
        .caso-info h3 { font-size: 16px; margin-bottom: 10px; }
        .caso-info p { margin-bottom: 8px; font-size: 14px; line-height: 1.6; }
        .respuesta { background: #eef6ff; border-left: 4px solid #4f8ef7; margin-bottom: 15px; padding: 12px 15px; border-radius: 6px; }
        .respuesta .header { font-weight: 600; margin-bottom: 8px; }
        .no-casos { text-align: center; padding: 40px 20px; color: #999; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Seguimiento de Reclamos</h1>
        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>
        <?php if (empty($caso)): ?>
            <form method="POST" action="">
                <label for="rut">RUT</label>
                <input type="text" name="rut" id="rut" placeholder="12.345.678-9" maxlength="12" pattern="[0-9.\-Kk]+" title="Formato: 12.345.678-9" required>
                <label for="numero_caso">Número de Caso</label>
                <input type="text" name="numero_caso" id="numero_caso" placeholder="AGUA-REC-00001" required>
                <button type="submit">Buscar Caso</button>
            </form>
        <?php else: ?>
            <div class="caso-info">
                <h3><?php echo htmlspecialchars($caso['numero_caso']) . " - " . htmlspecialchars($caso['empresa_nombre']); ?></h3>
                <p><strong>Cliente:</strong> <?php echo htmlspecialchars($caso['cliente_nombre']); ?></p>
                <p><strong>Tipo:</strong> <?php echo ucfirst(htmlspecialchars($caso['tipo_caso'])); ?></p>
                <p><strong>Estado:</strong> <?php echo ESTADOS_CASO[$caso['estado']] ?? $caso['estado']; ?></p>
                <p><strong>Prioridad:</strong> <?php echo PRIORIDADES_CASO[$caso['prioridad']] ?? $caso['prioridad']; ?></p>
                <p><strong>Asunto:</strong> <?php echo htmlspecialchars($caso['asunto']); ?></p>
                <p><strong>Descripción:</strong></p>
                <p><?php echo nl2br(htmlspecialchars($caso['descripcion'])); ?></p>
            </div>
            <h3>Respuestas</h3>
            <?php if (empty($respuestas)): ?>
                <p class="no-casos">No hay respuestas para este caso.</p>
            <?php else: ?>
                <?php foreach ($respuestas as $resp): ?>
                    <div class="respuesta">
                        <div class="header"><?php echo htmlspecialchars($resp['usuario_nombre']); ?> - <?php echo date('d/m/Y H:i', strtotime($resp['fecha_respuesta'])); ?></div>
                        <div><?php echo nl2br(htmlspecialchars($resp['contenido_respuesta'])); ?></div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</body>
</html>
