<?php
/**
 * Portal Cliente - Listado de Reclamos
 * Versión: 2.0 Definitiva
 */

session_start();

if (!isset($_SESSION['cliente_id'])) {
    header('Location: /portal/login.php');
    exit;
}

require_once __DIR__ . '/../config/configuracion.php';
require_once __DIR__ . '/../config/conexion.php';
require_once __DIR__ . '/../lib/funciones_comunes.php';

$cliente_id = $_SESSION['cliente_id'];

$pagina = intval($_GET['pagina'] ?? 1);
$por_pagina = 15;
$offset = ($pagina - 1) * $por_pagina;

// Contar total reclamos
$query_count = "SELECT COUNT(*) as total FROM casos WHERE cliente_id = ?";
$total_row = obtener_fila($query_count, 'i', [$cliente_id]);
$total_reclamos = $total_row['total'] ?? 0;
$total_paginas = ceil($total_reclamos / $por_pagina);

// Obtener reclamos paginados
$query = "SELECT * FROM casos WHERE cliente_id = ? ORDER BY fecha_creacion DESC LIMIT ? OFFSET ?";
$reclamos = obtener_filas($query, 'iii', [$cliente_id, $por_pagina, $offset]);

?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Mis Reclamos - <?php echo APP_NAME; ?></title>
<style>
body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background:#eef2f7; margin:0; padding:0; }
.container { max-width: 900px; margin: 40px auto; padding: 20px; background: white; border-radius: 8px; box-shadow: 0 3px 6px rgba(0,0,0,0.1);}
h1 {text-align: center; margin-bottom: 20px;}
table { width: 100%; border-collapse: collapse; }
th, td { padding: 12px 15px; border-bottom: 1px solid #ddd; text-align: left; font-size: 14px; }
th { background: #f8f9fa; font-weight: 600; color: #555; }
tr:hover { background: #f1f1f1; cursor: pointer; }
.pagination { text-align: center; margin-top: 20px; }
.pagination a, .pagination span { margin: 0 5px; padding: 8px 12px; border: 1px solid #ccc; border-radius: 5px; text-decoration: none; color: #333;}
.pagination .active { background: #667eea; color: white; border-color: #667eea; }
.logout-link { display: block; margin-top: 25px; text-align: center; color: #667eea; text-decoration: none; font-weight: 600; }
.logout-link:hover { text-decoration: underline; }
</style>
</head>
<body>
<div class="container">
    <h1>Mis Reclamos</h1>
    <?php if(empty($reclamos)): ?>
        <p>No has registrado reclamos aún.</p>
    <?php else: ?>
    <table>
        <thead>
            <tr>
                <th>Número Caso</th>
                <th>Asunto</th>
                <th>Tipo</th>
                <th>Estado</th>
                <th>Creación</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($reclamos as $rec): ?>
            <tr onclick="window.location='/portal/reclamo_ver.php?id=<?php echo $rec['id']; ?>'">
                <td><?php echo htmlspecialchars($rec['numero_caso']); ?></td>
                <td><?php echo htmlspecialchars($rec['asunto']); ?></td>
                <td><?php echo ucfirst(htmlspecialchars($rec['tipo_caso'])); ?></td>
                <td><?php echo ESTADOS_CASO[$rec['estado']] ?? htmlspecialchars($rec['estado']); ?></td>
                <td><?php echo date('d-m-Y H:i', strtotime($rec['fecha_creacion'])); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <?php if($total_paginas > 1): ?>
    <div class="pagination">
        <?php for($i = max(1,$pagina-2); $i <= min($total_paginas,$pagina+2); $i++): ?>
            <?php if($i==$pagina): ?>
                <span class="active"><?php echo $i; ?></span>
            <?php else: ?>
                <a href="?pagina=<?php echo $i; ?>"><?php echo $i; ?></a>
            <?php endif; ?>
        <?php endfor; ?>
    </div>
    <?php endif; ?>

    <?php endif; ?>

    <a href="/portal/logout.php" class="logout-link">Cerrar Sesión</a>
</div>
</body>
</html>
