<?php
/**
 * Portal Cliente - Ver Reclamo (Detalle y Adjuntos)
 * Versión: 2.1
 */

session_start();

if (!isset($_SESSION['cliente_id'])) {
    header('Location: /portal/login.php');
    exit;
}

require_once __DIR__ . '/../config/configuracion.php';
require_once __DIR__ . '/../config/conexion.php';
require_once __DIR__ . '/../lib/funciones_comunes.php';

$cliente_id = $_SESSION['cliente_id'];
$caso_id = intval($_GET['id'] ?? 0);

if ($caso_id <= 0) {
    header('Location: /portal/reclamos.php');
    exit;
}

// Obtener detalle del reclamo y validar propiedad
$query = "SELECT c.*, e.nombre as empresa_nombre
          FROM casos c
          JOIN empresas e ON c.empresa_id = e.id
          WHERE c.id = ? AND c.cliente_id = ?";

$caso = obtener_fila($query, 'ii', [$caso_id, $cliente_id]);
if (!$caso) {
    header('Location: /portal/reclamos.php');
    exit;
}

// Obtener respuestas asociadas
$query_resp = "SELECT r.*, u.nombre as usuario_nombre 
               FROM respuestas r
               LEFT JOIN usuarios u ON r.usuario_id = u.id
               WHERE r.caso_id = ?
               ORDER BY r.fecha_respuesta DESC";

$respuestas = obtener_filas($query_resp, 'i', [$caso_id]);

// Obtener archivos adjuntos
$archivos = obtener_filas("SELECT * FROM archivos_reclamos WHERE reclamo_id = ?", 'i', [$caso_id]);

?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Detalle Reclamo <?php echo htmlspecialchars($caso['numero_caso']); ?> - <?php echo APP_NAME; ?></title>
<style>
body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background: #eef2f7; color: #333; margin: 0; padding: 0; }
.container { max-width: 900px; margin: 40px auto; padding: 25px; background: white; border-radius: 8px; box-shadow: 0 3px 6px rgba(0,0,0,0.1); }
h1 { text-align: center; margin-bottom: 20px; }
section { margin-bottom: 30px; }
h2 { border-bottom: 2px solid #667eea; padding-bottom: 8px; margin-bottom: 15px; color: #334; }
p { font-size: 15px; line-height: 1.5; }
.respuesta { background: #f0f4ff; border-left: 4px solid #667eea; padding: 15px 20px; margin-bottom: 15px; border-radius: 6px; }
.respuesta .meta { font-size: 14px; color: #555; margin-bottom: 8px; }
.back-link { display: block; margin-bottom: 25px; color: #667eea; text-decoration: none; font-weight: 600; }
.back-link:hover { text-decoration: underline; }
.logout-link { display: block; margin-top: 20px; text-align: center; color: #667eea; text-decoration: none; font-weight: 600; }
.logout-link:hover { text-decoration: underline; }
ul { margin: 0; padding-left: 1.5em; }
</style>
</head>
<body>
<div class="container">
    <a href="/portal/reclamos.php" class="back-link">← Volver a Mis Reclamos</a>
    <h1>Detalle Reclamo <?php echo htmlspecialchars($caso['numero_caso']); ?></h1>

    <section>
        <h2>Información General</h2>
        <p><strong>Empresa:</strong> <?php echo htmlspecialchars($caso['empresa_nombre']); ?></p>
        <p><strong>Asunto:</strong> <?php echo htmlspecialchars($caso['asunto']); ?></p>
        <p><strong>Tipo:</strong> <?php echo ucfirst(htmlspecialchars($caso['tipo_caso'])); ?></p>
        <p><strong>Estado:</strong> <?php echo ESTADOS_CASO[$caso['estado']] ?? htmlspecialchars($caso['estado']); ?></p>
        <p><strong>Descripción:</strong></p>
        <p><?php echo nl2br(htmlspecialchars($caso['descripcion'])); ?></p>
        <p><strong>Fecha de creación:</strong> <?php echo date('d-m-Y H:i', strtotime($caso['fecha_creacion'])); ?></p>
    </section>

    <section>
        <h2>Documentos Adjuntos</h2>
        <?php if (empty($archivos)): ?>
            <p>No hay archivos adjuntos.</p>
        <?php else: ?>
            <ul>
                <?php foreach ($archivos as $archivo): ?>
                    <li>
                        <a href="/portal/uploads/reclamos/<?php echo htmlspecialchars($archivo['ruta_archivo']); ?>" target="_blank">
                            <?php echo htmlspecialchars($archivo['nombre_original']); ?>
                        </a>
                    </li>
                <?php endforeach; ?>
            </ul>
        <?php endif; ?>
    </section>

    <section>
        <h2>Respuestas y Seguimiento</h2>
        <?php if (empty($respuestas)): ?>
            <p>No hay respuestas para este reclamo aún.</p>
        <?php else: ?>
            <?php foreach ($respuestas as $resp): ?>
                <div class="respuesta">
                    <div class="meta">
                        <?php echo htmlspecialchars($resp['usuario_nombre'] ?: 'Sistema'); ?>
                        - <?php echo date('d-m-Y H:i', strtotime($resp['fecha_respuesta'])); ?>
                    </div>
                    <div class="contenido"><?php echo nl2br(htmlspecialchars($resp['contenido_respuesta'])); ?></div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </section>

    <a href="/portal/logout.php" class="logout-link">Cerrar Sesión</a>
</div>
</body>
</html>
