<?php
/**
 * Portal Cliente - Crear Reclamo con Adjuntos
 * Versión: 1.0
 */

session_start();

if (!isset($_SESSION['cliente_id'])) {
    header('Location: /portal/login.php');
    exit;
}

require_once __DIR__ . '/../config/configuracion.php';
require_once __DIR__ . '/../config/conexion.php';
require_once __DIR__ . '/../lib/funciones_comunes.php';

$error = '';
$exito = '';
$cliente_id = $_SESSION['cliente_id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $asunto = limpiar_entrada($_POST['asunto'] ?? '');
    $descripcion = limpiar_entrada($_POST['descripcion'] ?? '');

    if (empty($asunto) || empty($descripcion)) {
        $error = 'Debe completar todos los campos obligatorios';
    } else {
        // Insertar reclamo con cliente_id asociado
        $query = "INSERT INTO casos (cliente_id, asunto, descripcion, fecha_creacion, estado) VALUES (?, ?, ?, NOW(), 'nuevo')";
        $id_reclamo = insertar($query, 'iss', [$cliente_id, $asunto, $descripcion]);

        if ($id_reclamo) {
            $archivos_guardados = [];
            $target_dir = __DIR__ . "/uploads/reclamos/";
            if (!file_exists($target_dir)) {
                mkdir($target_dir, 0755, true);
            }
            
            if (isset($_FILES['archivos']) && is_array($_FILES['archivos']['tmp_name'])) {
                foreach ($_FILES['archivos']['tmp_name'] as $index => $tmp_name) {
                    if ($_FILES['archivos']['error'][$index] === UPLOAD_ERR_OK) {
                        $nombre_original = basename($_FILES['archivos']['name'][$index]);
                        $ext = strtolower(pathinfo($nombre_original, PATHINFO_EXTENSION));
                        $nombre_generado = uniqid('rec_', true) . '.' . $ext;
                        $ruta_destino = $target_dir . $nombre_generado;

                        // Validar extensiones permitidas
                        $ext_permitidas = ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx'];
                        if (!in_array($ext, $ext_permitidas)) {
                            continue; // Ignorar archivo no permitido
                        }

                        $tipo_mime = mime_content_type($tmp_name);

                        if (move_uploaded_file($tmp_name, $ruta_destino)) {
                            $tamano = $_FILES['archivos']['size'][$index];
                            $queryArchivo = "INSERT INTO archivos_reclamos (reclamo_id, nombre_original, ruta_archivo, tipo_mime, tamano, fecha_subida) VALUES (?, ?, ?, ?, ?, NOW())";
                            ejecutar_query($queryArchivo, 'isssi', [$id_reclamo, $nombre_original, $nombre_generado, $tipo_mime, $tamano]);
                            $archivos_guardados[] = $nombre_original;
                        }
                    }
                }
            }
            $exito = 'Reclamo creado correctamente.';
            if ($archivos_guardados) {
                $exito .= ' Archivos subidos: ' . implode(', ', $archivos_guardados);
            }
            $_POST = [];
        } else {
            $error = 'Error al crear el reclamo.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Crear Reclamo - <?php echo APP_NAME; ?></title>
<style>
    body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background:#eef2f7; margin:0; padding:0; }
    .container { max-width: 600px; margin: 50px auto; padding: 25px; background: white; border-radius: 8px; box-shadow: 0 3px 6px rgba(0,0,0,0.1); }
    h1 { text-align: center; margin-bottom: 20px; }
    label { display: block; margin-bottom: 6px; font-weight: 600; }
    input[type=text], textarea, input[type=file] { width: 100%; padding: 10px 12px; margin-bottom: 15px; border-radius: 6px; border: 1px solid #ccc; font-size: 14px; }
    textarea { min-height: 100px; resize: vertical; }
    button { width: 100%; padding: 12px; font-weight: 600; background: #667eea; border: none; border-radius: 6px; color: white; cursor: pointer; font-size: 16px;}
    button:hover { background: #5568d3; }
    .alert-error { background: #fee; color: #c33; padding: 12px 15px; margin-bottom: 20px; border-radius: 6px; font-weight: 600; }
    .alert-success { background: #efe; color: #3c3; padding: 12px 15px; margin-bottom: 20px; border-radius: 6px; font-weight: 600; }
</style>
</head>
<body>
<div class="container">
    <h1>Crear Nuevo Reclamo</h1>
    <?php if ($error): ?>
        <div class="alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if ($exito): ?>
        <div class="alert-success"><?php echo htmlspecialchars($exito); ?></div>
    <?php endif; ?>
    <form action="" method="POST" enctype="multipart/form-data">
        <label for="asunto">Asunto*</label>
        <input type="text" id="asunto" name="asunto" maxlength="255" required value="<?php echo htmlspecialchars($_POST['asunto'] ?? ''); ?>">

        <label for="descripcion">Descripción*</label>
        <textarea id="descripcion" name="descripcion" required><?php echo htmlspecialchars($_POST['descripcion'] ?? ''); ?></textarea>

        <label for="archivos">Adjuntar Archivos (opcional)</label>
        <input type="file" id="archivos" name="archivos[]" multiple>

        <button type="submit">Crear Reclamo</button>
    </form>
</div>
</body>
</html>
