<?php
/**
 * Portal Cliente - Editar Perfil
 * Versión: 2.0 Definitiva
 */

session_start();

if (!isset($_SESSION['cliente_id'])) {
    header('Location: /portal/login.php');
    exit;
}

require_once __DIR__ . '/../config/configuracion.php';
require_once __DIR__ . '/../config/conexion.php';
require_once __DIR__ . '/../lib/funciones_comunes.php';

$cliente_id = $_SESSION['cliente_id'];

$error = '';
$exito = '';

// Obtener datos actuales del cliente
$cliente = obtener_fila("SELECT * FROM clientes WHERE id = ?", 'i', [$cliente_id]);
if (!$cliente) {
    // Sesión inválida, cerrar sesión
    session_destroy();
    header('Location: /portal/login.php');
    exit;
}

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf_token = $_POST['csrf_token'] ?? '';
    if (!verificar_csrf_token($csrf_token)) {
        $error = 'Token de seguridad inválido';
    } else {
        $nombre = limpiar_entrada($_POST['nombre'] ?? '');
        $email = limpiar_entrada($_POST['email'] ?? '');
        $telefono = limpiar_entrada($_POST['telefono'] ?? '');
        $password_actual = $_POST['password_actual'] ?? '';
        $password_nuevo = $_POST['password_nuevo'] ?? '';
        $password_confirm = $_POST['password_confirm'] ?? '';

        if (empty($nombre)) {
            $error = 'El nombre es obligatorio';
        } elseif (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = 'El email no es válido';
        } elseif (!empty($password_nuevo)) {
            // Verificar contraseña actual
            if (!password_verify($password_actual, $cliente['password_hash'])) {
                $error = 'Contraseña actual incorrecta';
            } elseif ($password_nuevo !== $password_confirm) {
                $error = 'La confirmación de la nueva contraseña no coincide';
            } elseif (strlen($password_nuevo) < 6) {
                $error = 'La nueva contraseña debe tener al menos 6 caracteres';
            }
        }

        if (!$error) {
            $params = [$nombre, $email, $telefono, $cliente_id];
            $types = 'sssi';
            $query = "UPDATE clientes SET nombre = ?, email = ?, telefono = ?";

            if (!empty($password_nuevo)) {
                $password_hash = password_hash($password_nuevo, PASSWORD_DEFAULT);
                $query .= ", password_hash = ?";
                $params[] = $password_hash;
                $types .= 's';
            }

            $query .= " WHERE id = ?";

            $ok = ejecutar_query($query, $types, $params);
            if ($ok) {
                registrar_log_seguridad("Perfil actualizado: $nombre", $cliente_id);
                $exito = 'Datos actualizados exitosamente';
                if (!empty($password_nuevo)) {
                    // Actualizar sesión o pedir re-login si necesario
                }
                // Refrescar datos cliente para mostrar cambios
                $cliente = obtener_fila("SELECT * FROM clientes WHERE id = ?", 'i', [$cliente_id]);
            } else {
                $error = 'Error al actualizar perfil';
            }
        }
    }
}

$csrf_token = generar_csrf_token();
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Perfil Cliente - <?php echo APP_NAME; ?></title>
<style>
body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background:#eef2f7; margin:0; padding:0; }
.container { max-width: 500px; margin: 50px auto; padding: 20px; background: white; border-radius: 8px; box-shadow: 0 3px 6px rgba(0,0,0,0.1);}
h1 { text-align: center; margin-bottom: 20px; }
form label { display: block; margin-bottom: 6px; font-weight: 600; }
input[type=text], input[type=email], input[type=password] { width: 100%; padding: 10px 12px; margin-bottom: 15px; border-radius: 6px; border: 1px solid #ccc; font-size: 14px; }
button { width: 100%; padding: 12px; font-weight: 600; background: #667eea; border: none; border-radius: 6px; color: white; cursor: pointer; font-size: 16px; }
button:hover { background: #5568d3; }
.alert-error { background: #fee; padding: 12px; border: 1px solid #fcc; border-radius: 6px; color: #c33; margin-bottom: 20px; font-weight: 600; }
.alert-success { background: #efe; padding: 12px; border: 1px solid #cfc; border-radius: 6px; color: #3c3; margin-bottom: 20px; font-weight: 600; }
a.logout-link { display: block; margin-top: 20px; text-align: center; color: #667eea; font-weight: 600; cursor: pointer; }
a.logout-link:hover { text-decoration: underline; }
</style>
</head>
<body>
<div class="container">
    <h1>Perfil de Cliente</h1>
    <?php if ($error): ?>
        <div class="alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if ($exito): ?>
        <div class="alert-success"><?php echo htmlspecialchars($exito); ?></div>
    <?php endif; ?>
    <form method="POST" action="">
        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
        <label for="nombre">Nombre Completo</label>
        <input type="text" id="nombre" name="nombre" required maxlength="255" value="<?php echo htmlspecialchars($cliente['nombre']); ?>">
        <label for="email">Correo Electrónico</label>
        <input type="email" id="email" name="email" maxlength="255" value="<?php echo htmlspecialchars($cliente['email']); ?>">
        <label for="telefono">Teléfono</label>
        <input type="text" id="telefono" name="telefono" maxlength="20" value="<?php echo htmlspecialchars($cliente['telefono']); ?>">
        <hr>
        <label for="password_actual">Contraseña Actual</label>
        <input type="password" id="password_actual" name="password_actual" placeholder="Ingrese su contraseña actual para cambiarla">
        <label for="password_nuevo">Nueva Contraseña</label>
        <input type="password" id="password_nuevo" name="password_nuevo" minlength="6" placeholder="Nueva contraseña">
        <label for="password_confirm">Confirmar Nueva Contraseña</label>
        <input type="password" id="password_confirm" name="password_confirm" minlength="6" placeholder="Confirmar nueva contraseña">
        <button type="submit">Guardar Cambios</button>
    </form>
    <a href="/portal/logout.php" class="logout-link">Cerrar Sesión</a>
</div>
</body>
</html>
