<?php
session_start();

require_once __DIR__ . '/../config/configuracion.php';
require_once __DIR__ . '/../config/conexion.php';
require_once __DIR__ . '/../lib/funciones_comunes.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $empresa_id = intval($_POST['empresa_id'] ?? 0);

    if (!$email || !$password || !$empresa_id) {
        $error = 'Completa todos los campos';
    } else {
        $query = "SELECT id, empresa_id, nombre, email, password_hash, rol FROM usuarios WHERE email = ? AND empresa_id = ? AND activo=1";
        $usuario = obtener_fila($query, 'si', [$email, $empresa_id]);

        if (!$usuario || !password_verify($password, $usuario['password_hash'])) {
            $error = 'Email o contraseña incorrectos';
        } else {
            // Login exitoso
            $_SESSION['usuario_id'] = $usuario['id'];
            $_SESSION['empresa_id'] = $usuario['empresa_id'];
            $_SESSION['usuario_nombre'] = $usuario['nombre'];
            $_SESSION['usuario_rol'] = $usuario['rol'];

            header('Location: /portal/perfil.php');
            exit;
        }
    }
}

// Listar empresas para select en login
$empresas = obtener_filas("SELECT id, nombre FROM empresas WHERE activo = 1 ORDER BY nombre");

?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Login Multiempresa</title>
<style>
/* Estilos simples aquí o enlazar CSS */
body { font-family: Arial, sans-serif; background:#eef2f7; display:flex; justify-content:center; align-items:center; height:100vh; margin:0; }
.container { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); width: 320px; }
h1 { text-align: center; margin-bottom: 20px; }
label { display: block; margin-bottom: 6px; font-weight: bold; }
input, select { width: 100%; padding: 8px 12px; margin-bottom: 15px; border-radius: 6px; border: 1px solid #ccc; font-size: 14px; }
button { width: 100%; padding: 10px; background: #667eea; border: none; border-radius: 6px; color: white; font-weight: bold; cursor: pointer;}
button:hover { background: #5568d3; }
.alert { background: #fee; color: #c33; padding: 10px 12px; margin-bottom: 15px; border-radius: 6px; font-weight: bold; }
</style>
</head>
<body>
<div class="container">
    <h1>Login</h1>
    <?php if ($error): ?>
        <div class="alert"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <form method="POST" action="">
        <label for="empresa_id">Empresa</label>
        <select name="empresa_id" id="empresa_id" required>
            <option value="">Seleccione una empresa</option>
            <?php foreach ($empresas as $empresa): ?>
                <option value="<?php echo $empresa['id']; ?>"><?php echo htmlspecialchars($empresa['nombre']); ?></option>
            <?php endforeach; ?>
        </select>

        <label for="email">Correo electrónico</label>
        <input type="email" name="email" id="email" required autofocus>

        <label for="password">Contraseña</label>
        <input type="password" name="password" id="password" required>

        <button type="submit">Ingresar</button>
    </form>
</div>
</body>
</html>
