<?php
/**
 * Portal Cliente - Login
 * Versión: 2.0 Definitiva
 */

session_start();

// Redirige si ya está autenticado
if (isset($_SESSION['cliente_id'])) {
    header('Location: /portal/perfil.php');
    exit;
}

require_once __DIR__ . '/../config/configuracion.php';
require_once __DIR__ . '/../config/conexion.php';
require_once __DIR__ . '/../lib/funciones_comunes.php';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rut_o_email = trim($_POST['rut_o_email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($rut_o_email) || empty($password)) {
        $error = 'Debe ingresar RUT o Email y contraseña';
    } else {
        // Buscar cliente por RUT (normalizado) o email
        $cliente = obtener_fila(
            "SELECT * FROM clientes WHERE (rut = ? OR email = ?) AND activo = 1",
            'ss',
            [$rut_o_email, $rut_o_email]
        );
        
        if (!$cliente) {
            $error = 'No se encontró usuario activo con esos datos';
        } else if (!password_verify($password, $cliente['password_hash'])) {
            $error = 'Contraseña incorrecta';
        } else {
            // Login exitoso
            $_SESSION['cliente_id'] = $cliente['id'];
            $_SESSION['cliente_nombre'] = $cliente['nombre'];
            $_SESSION['cliente_rut'] = $cliente['rut'];
            
            // Registrar último acceso
            ejecutar_query("UPDATE clientes SET fecha_ultimo_acceso = NOW() WHERE id = ?", 'i', [$cliente['id']]);
            
            header('Location: /portal/perfil.php');
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Portal Cliente - Login | <?php echo APP_NAME; ?></title>
<style>
    body {font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, sans-serif; background:#eef2f7; margin:0; padding:0;}
    .container {max-width: 400px; margin: 50px auto; padding: 30px; background: white; border-radius: 8px; box-shadow: 0 2px 5px rgba(0,0,0,0.1);}
    h1 {text-align: center; margin-bottom: 25px;}
    label {display: block; font-weight: 600; margin-bottom: 5px;}
    input[type="text"], input[type="password"] {width: 100%; padding: 10px; margin-bottom: 20px; border-radius: 6px; border: 1px solid #ddd; font-size: 14px; font-family: inherit;}
    button {width: 100%; padding: 12px; font-size: 16px; border:none; border-radius: 6px; background: #667eea; color: white; font-weight: 600; cursor: pointer;}
    button:hover {background: #5568d3;}
    .alert-error {background:#fee; border:1px solid #fcc; padding:12px; margin-bottom:20px; border-radius: 6px; color: #c33; font-weight: 600;}
</style>
</head>
<body>
    <div class="container">
        <h1>Ingreso Portal Cliente</h1>
        <?php if($error): ?>
            <div class="alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        <form method="POST" action="">
            <label for="rut_o_email">RUT o Email</label>
            <input type="text" id="rut_o_email" name="rut_o_email" maxlength="255" required 
                   value="<?php echo htmlspecialchars($_POST['rut_o_email'] ?? ''); ?>" autofocus>
            
            <label for="password">Contraseña</label>
            <input type="password" id="password" name="password" required minlength="6">
            
            <button type="submit">Ingresar</button>
        </form>
    </div>
</body>
</html>
