<?php
/**
 * Portal Público - Envío de Reclamos con Adjuntos
 * Versión: 2.1
 */

session_start();

require_once __DIR__ . '/../config/configuracion.php';
require_once __DIR__ . '/../config/conexion.php';
require_once __DIR__ . '/../lib/funciones_comunes.php';

$error = '';
$exito = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $rut = limpiar_entrada($_POST['rut'] ?? '');
    $nombre = limpiar_entrada($_POST['nombre'] ?? '');
    $email = limpiar_entrada($_POST['email'] ?? '');
    $telefono = limpiar_entrada($_POST['telefono'] ?? '');
    $asunto = limpiar_entrada($_POST['asunto'] ?? '');
    $descripcion = limpiar_entrada($_POST['descripcion'] ?? '');

    // Validaciones básicas
    if (empty($rut) || empty($nombre) || empty($asunto) || empty($descripcion)) {
        $error = 'Debe completar todos los campos obligatorios.';
    } elseif (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Email no válido.';
    } else {
        // Insertar reclamo
        $query = "INSERT INTO casos (rut, nombre_cliente, email, telefono, asunto, descripcion, fecha_creacion, estado) VALUES (?, ?, ?, ?, ?, ?, NOW(), 'nuevo')";
        $id_reclamo = insertar($query, 'ssssss', [$rut, $nombre, $email, $telefono, $asunto, $descripcion]);

        if ($id_reclamo) {
            $archivos_guardados = [];
            $target_dir = __DIR__ . "/uploads/reclamos/";

            if (!file_exists($target_dir)) {
                mkdir($target_dir, 0755, true);
            }

            // Procesar archivos adjuntos
            if (isset($_FILES['archivos']) && is_array($_FILES['archivos']['tmp_name'])) {
                foreach ($_FILES['archivos']['tmp_name'] as $index => $tmp_name) {
                    if ($_FILES['archivos']['error'][$index] === UPLOAD_ERR_OK) {
                        $nombre_original = basename($_FILES['archivos']['name'][$index]);
                        $ext = strtolower(pathinfo($nombre_original, PATHINFO_EXTENSION));
                        $nombre_generado = uniqid('rec_', true) . '.' . $ext;
                        $ruta_destino = $target_dir . $nombre_generado;

                        // Validar extensión permitida
                        $ext_permitidas = ['jpg', 'jpeg', 'png', 'pdf', 'doc', 'docx'];
                        if (!in_array($ext, $ext_permitidas)) {
                            continue; // Ignorar archivo no permitido
                        }

                        $tipo_mime = mime_content_type($tmp_name);

                        if (move_uploaded_file($tmp_name, $ruta_destino)) {
                            $tamano = $_FILES['archivos']['size'][$index];
                            $queryArchivo = "INSERT INTO archivos_reclamos (reclamo_id, nombre_original, ruta_archivo, tipo_mime, tamano, fecha_subida) VALUES (?, ?, ?, ?, ?, NOW())";
                            ejecutar_query($queryArchivo, 'isssi', [$id_reclamo, $nombre_original, $nombre_generado, $tipo_mime, $tamano]);
                            $archivos_guardados[] = $nombre_original;
                        }
                    }
                }
            }
            $exito = 'Reclamo enviado correctamente.';
            if (count($archivos_guardados) > 0) {
                $exito .= ' Archivos subidos: ' . implode(', ', $archivos_guardados);
            }
            // Limpiar campos
            $_POST = [];
        } else {
            $error = 'Error al enviar el reclamo.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Enviar Reclamo - <?php echo APP_NAME; ?></title>
<style>
    body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen, Ubuntu, sans-serif; background:#eef2f7; margin:0; padding:0; }
    .container { max-width: 600px; margin: 50px auto; padding: 25px; background: white; border-radius: 8px; box-shadow: 0 3px 6px rgba(0,0,0,0.1); }
    h1 { text-align: center; margin-bottom: 20px; }
    label { display: block; margin-bottom: 6px; font-weight: 600; }
    input[type=text], input[type=email], textarea, input[type=file] {
        width: 100%; padding: 10px 12px; margin-bottom: 15px; border-radius: 6px; border: 1px solid #ccc; font-size: 14px; font-family: inherit;
    }
    textarea { resize: vertical; min-height: 100px; }
    button { width: 100%; padding: 12px; font-weight: 600; background: #667eea; border: none; border-radius: 6px; color: white; cursor: pointer; font-size: 16px;}
    button:hover { background: #5568d3; }
    .alert-error { background: #fee; color: #c33; padding: 12px 15px; margin-bottom: 20px; border-radius: 6px; font-weight: 600; }
    .alert-success { background: #efe; color: #3c3; padding: 12px 15px; margin-bottom: 20px; border-radius: 6px; font-weight: 600; }
</style>
</head>
<body>
<div class="container">
    <h1>Enviar Reclamo</h1>
    <?php if ($error): ?>
        <div class="alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    <?php if ($exito): ?>
        <div class="alert-success"><?php echo htmlspecialchars($exito); ?></div>
    <?php endif; ?>
    <form action="" method="POST" enctype="multipart/form-data">
        <label for="rut">RUT*</label>
        <input type="text" id="rut" name="rut" maxlength="12" required pattern="[0-9.\-Kk]+" title="Formato: 12.345.678-9" value="<?php echo htmlspecialchars($_POST['rut'] ?? ''); ?>">

        <label for="nombre">Nombre Completo*</label>
        <input type="text" id="nombre" name="nombre" maxlength="255" required value="<?php echo htmlspecialchars($_POST['nombre'] ?? ''); ?>">

        <label for="email">Correo Electrónico</label>
        <input type="email" id="email" name="email" maxlength="255" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">

        <label for="telefono">Teléfono</label>
        <input type="text" id="telefono" name="telefono" maxlength="20" value="<?php echo htmlspecialchars($_POST['telefono'] ?? ''); ?>">

        <label for="asunto">Asunto*</label>
        <input type="text" id="asunto" name="asunto" maxlength="255" required value="<?php echo htmlspecialchars($_POST['asunto'] ?? ''); ?>">

        <label for="descripcion">Descripción*</label>
        <textarea id="descripcion" name="descripcion" required><?php echo htmlspecialchars($_POST['descripcion'] ?? ''); ?></textarea>

        <label for="archivos">Adjuntar Archivos (opcional)</label>
        <input type="file" id="archivos" name="archivos[]" multiple>

        <button type="submit">Enviar Reclamo</button>
    </form>
</div>
</body>
</html>
