<?php
/**
 * Listado de Usuarios
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

if (!verificar_sesion()) {
    redireccionar('/login');
}

// Solo admin_empresa y superadmin pueden gestionar usuarios.
$usuario_id = $_SESSION['usuario_id'];
$usuario_nombre = $_SESSION['usuario_nombre'];
$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

if (!in_array($usuario_rol, ['admin_empresa', 'superadmin'])) {
    redireccionar('/dashboard');
}

// Filtros
$rol_filtro = $_GET['rol'] ?? '';
$estado_filtro = $_GET['estado'] ?? '';
$empresa_filtro = $_GET['empresa_id'] ?? '';
$search = trim($_GET['search'] ?? '');
$pagina = intval($_GET['pagina'] ?? 1);
$por_pagina = 20;
$offset = ($pagina - 1) * $por_pagina;

// WHERE
$where = ['1=1'];
$params = [];
$types = '';

// Admin_empresa solo ve usuarios de su empresa
if ($usuario_rol === 'admin_empresa') {
    $where[] = 'u.empresa_id = ?';
    $params[] = $empresa_id;
    $types .= 'i';
} elseif ($empresa_filtro && $empresa_filtro !== 'todas') {
    $where[] = 'u.empresa_id = ?';
    $params[] = $empresa_filtro;
    $types .= 'i';
}

// Rol filtro
if ($rol_filtro) {
    $where[] = 'u.rol = ?';
    $params[] = $rol_filtro;
    $types .= 's';
}

// Estado filtro
if ($estado_filtro !== '') {
    $where[] = 'u.activo = ?';
    $params[] = ($estado_filtro === '1') ? 1 : 0;
    $types .= 'i';
}

// Busqueda general
if ($search) {
    $where[] = '(u.nombre LIKE ? OR u.email LIKE ?)';
    $param = '%' . $search . '%';
    $params[] = $param; $params[] = $param;
    $types .= 'ss';
}
$where_sql = implode(' AND ', $where);

// Empresas para filtro
$empresas = [];
if ($usuario_rol === 'superadmin') {
    $empresas = obtener_filas("SELECT id, nombre FROM empresas WHERE activa = 1 ORDER BY nombre");
}

// Contar usuarios
$query_c = "SELECT COUNT(*) as total FROM usuarios u WHERE $where_sql";
$total_row = obtener_fila($query_c, $types, $params);
$total_usuarios = $total_row['total'] ?? 0;
$total_paginas = ceil($total_usuarios / $por_pagina);

// Usuarios
$query = "SELECT u.*, e.nombre as empresa_nombre FROM usuarios u
          LEFT JOIN empresas e ON u.empresa_id = e.id
          WHERE $where_sql
          ORDER BY u.rol, u.nombre
          LIMIT ? OFFSET ?";

$params_p = array_merge($params, [$por_pagina, $offset]);
$types_p = $types . 'ii';

$usuarios = obtener_filas($query, $types_p, $params_p);

$flash = get_flash();

// ROLES para filtro/select
$roles_opciones = [
    'superadmin' => 'Super Administrador',
    'admin_empresa' => 'Administrador Empresa',
    'directorio' => 'Directorio',
    'ejecutivo' => 'Ejecutivo',
    'supervisor' => 'Supervisor',
    'cliente' => 'Cliente'
];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Usuarios - <?php echo APP_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background: #f5f7fa; color: #333; }
        .navbar { background: white; border-bottom: 1px solid #e1e4e8; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 2px 4px rgb(0 0 0 / 0.05); }
        .navbar-brand { font-size: 18px; font-weight: 600; color: #333; text-decoration: none; }
        .navbar-user { display: flex; align-items: center; gap: 20px; }
        .btn-logout { padding: 8px 16px; background: #dc3545; color: white; border-radius: 4px; font-size: 14px; text-decoration: none; }
        .container { max-width: 1400px; margin: 30px auto; padding: 0 30px; }
        .page-header { margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center; }
        .page-header h1 { font-size: 28px; margin-bottom: 0; }
        .btn { padding: 10px 20px; border-radius: 6px; text-decoration: none; font-size: 14px; font-weight: 500; border: none; cursor: pointer; transition: all 0.3s; }
        .btn-primary { background: #667eea; color: white; }
        .btn-primary:hover { background: #5568d3; }
        .btn-secondary { background: #6c757d; color: white; }
        .btn-secondary:hover { background: #565e64; }
        .btn-danger { background: #dc3545; color: white; }
        .btn-danger:hover { background: #c82333; }
        .btn-small { font-size: 12px; padding: 7px 14px; }
        .filters { display: grid; grid-template-columns: repeat(auto-fit, minmax(170px, 1fr)); gap: 15px; margin-bottom: 20px; }
        .filter-group label { display: block; margin-bottom: 5px; font-size: 13px; font-weight: 500; color: #666; }
        .filter-group select, .filter-group input { width: 100%; padding: 8px 11px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; }
        .filter-actions { display: flex; gap: 10px; align-items: flex-end; }
        .stats-row { display: flex; gap: 15px; margin-bottom: 20px; font-size: 14px; color: #666; }
        .card { background: white; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); padding: 25px; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; }
        table th { background: #f8f9fa; padding: 12px; text-align: left; font-size: 13px; font-weight: 600; color: #666; border-bottom: 2px solid #e1e4e8; }
        table td { padding: 11px 12px; border-bottom: 1px solid #e1e4e8; font-size: 14px; }
        table tr:hover { background: #f8f9fa; cursor: pointer; }
        .badge { display: inline-block; padding: 4px 10px; border-radius: 11px; font-size: 12px; font-weight: 500; }
        .badge-activo { background: #e8f5e9; color: #388e3c; }
        .badge-inactivo { background: #fbe9e7; color: #d84315; }
        .badge-superadmin { background: #e3f2fd; color: #1976d2; }
        .badge-admin_empresa { background: #fff3e0; color: #f57c00; }
        .badge-ejecutivo { background: #ffe0b2; color: #795548; }
        .badge-cliente { background: #f8bbd0; color: #ad1457; }
        .pagination { display: flex; justify-content: center; gap: 5px; margin-top: 20px; }
        .pagination a, .pagination span { padding: 8px 12px; border: 1px solid #ddd; border-radius: 4px; text-decoration: none; color: #333; }
        .pagination .active { background: #667eea; color: white; border-color: #667eea; }
        .pagination a:hover { background: #f8f9fa; }
        .alert-success { background: #efe; color: #3c3; border: 1px solid #cfc; }
        .alert-error { background: #fee; color: #c33; border: 1px solid #fcc; }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="/dashboard" class="navbar-brand"><?php echo APP_NAME; ?></a>
        <div class="navbar-user">
            <span><strong><?php echo htmlspecialchars($usuario_nombre); ?></strong> (<?php echo ROLES[$usuario_rol]; ?>)</span>
            <a href="/logout" class="btn-logout">Cerrar Sesión</a>
        </div>
    </nav>
    
    <div class="container">
        <div class="page-header">
            <h1>Gestión de Usuarios</h1>
            <a href="/usuarios/crear" class="btn btn-primary">+ Nuevo Usuario</a>
        </div>
        <?php if ($flash): ?>
            <div class="alert-<?php echo $flash['tipo']; ?>" style="margin-bottom:20px;padding:14px 22px;border-radius:6px;font-size:15px;">
                <?php echo htmlspecialchars($flash['mensaje']); ?>
            </div>
        <?php endif; ?>
        <div class="card">
            <form method="GET" action="/usuarios">
                <div class="filters">
                    <div class="filter-group">
                        <label>Búsqueda</label>
                        <input type="text" name="search" placeholder="Nombre, Email..." value="<?php echo htmlspecialchars($search); ?>">
                    </div>
                    <div class="filter-group">
                        <label>Rol</label>
                        <select name="rol">
                            <option value="">Todos</option>
                            <?php foreach ($roles_opciones as $k=>$v): ?>
                                <option value="<?php echo $k; ?>" <?php echo ($rol_filtro === $k) ? 'selected' : ''; ?>><?php echo $v; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="filter-group">
                        <label>Estado</label>
                        <select name="estado">
                            <option value="">Todos</option>
                            <option value="1" <?php echo ($estado_filtro=='1') ? 'selected' : '';?>>Activo</option>
                            <option value="0" <?php echo ($estado_filtro==='0') ? 'selected' : '';?>>Inactivo</option>
                        </select>
                    </div>
                    <?php if ($usuario_rol === 'superadmin'): ?>
                    <div class="filter-group">
                        <label>Empresa</label>
                        <select name="empresa_id">
                            <option value="todas">Todas</option>
                            <?php foreach ($empresas as $emp): ?>
                                <option value="<?php echo $emp['id']; ?>" <?php echo ($empresa_filtro==$emp['id'])?'selected':''; ?>>
                                    <?php echo htmlspecialchars($emp['nombre']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php endif; ?>
                    <div class="filter-actions">
                        <button type="submit" class="btn btn-primary">Filtrar</button>
                        <a href="/usuarios" class="btn btn-secondary">Limpiar</a>
                    </div>
                </div>
            </form>
            <div class="stats-row">
                <strong>Total de usuarios:</strong> <?php echo number_format($total_usuarios); ?> |
                <strong>Página:</strong> <?php echo $pagina; ?> de <?php echo max(1, $total_paginas); ?>
            </div>
            <?php if (empty($usuarios)): ?>
                <div style="padding:30px;text-align:center;color:#999;">No hay usuarios registrados.</div>
            <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>Nombre</th>
                        <th>Email</th>
                        <th>Rol</th>
                        <th>Empresa</th>
                        <th>Estado</th>
                        <th>Últ. Acceso</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($usuarios as $row): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($row['nombre']); ?></td>
                        <td><?php echo htmlspecialchars($row['email']); ?></td>
                        <td><span class="badge badge-<?php echo $row['rol']; ?>"><?php echo ROLES[$row['rol']]; ?></span></td>
                        <td><?php echo htmlspecialchars($row['empresa_nombre'] ?? '—'); ?></td>
                        <td>
                            <?php if ($row['activo']): ?>
                                <span class="badge badge-activo">Activo</span>
                            <?php else: ?>
                                <span class="badge badge-inactivo">Inactivo</span>
                            <?php endif; ?>
                        </td>
                        <td><?php echo $row['fecha_ultimo_acceso'] ? date('d/m/Y H:i', strtotime($row['fecha_ultimo_acceso'])) : '—'; ?></td>
                        <td>
                            <a href="/usuarios/editar/<?php echo $row['id']; ?>" class="btn btn-primary btn-small">Editar</a>
                            <?php if ($row['activo']): ?>
                                <a href="/usuarios/eliminar/<?php echo $row['id']; ?>" class="btn btn-danger btn-small"
                                    onclick="return confirm('¿Desactivar este usuario?');">Desactivar</a>
                            <?php else: ?>
                                <a href="/usuarios/eliminar/<?php echo $row['id']; ?>" class="btn btn-secondary btn-small"
                                    onclick="return confirm('¿Reactivar este usuario?');">Reactivar</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <?php if ($total_paginas > 1): ?>
                <div class="pagination">
                <?php for ($i = max(1,$pagina-2); $i <= min($total_paginas,$pagina+2); $i++): ?>
                    <?php if ($i==$pagina): ?>
                        <span class="active"><?php echo $i; ?></span>
                    <?php else: ?>
                        <a href="?pagina=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>&rol=<?php echo $rol_filtro; ?>&estado=<?php echo $estado_filtro; ?>&empresa_id=<?php echo $empresa_filtro; ?>"><?php echo $i; ?></a>
                    <?php endif; ?>
                <?php endfor; ?>
                </div>
            <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
