<?php
/**
 * Activar/Desactivar Usuario
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_rol_actual = $_SESSION['usuario_rol'];
$empresa_id_actual = $_SESSION['empresa_id'];

if (!in_array($usuario_rol_actual, ['superadmin', 'admin_empresa'])) {
    redireccionar('/dashboard');
}

$id_usuario = intval($_GET['id'] ?? 0);
if ($id_usuario <= 0) {
    redireccionar('/usuarios');
}

// No permitir que un usuario se desactive a sí mismo
if ($id_usuario == $_SESSION['usuario_id']) {
    set_flash('No puede desactivar su propio usuario.', 'error');
    redireccionar('/usuarios');
}

// Obtener datos del usuario a modificar
$query = "SELECT * FROM usuarios WHERE id = ?";
$usuario_obj = obtener_fila($query, 'i', [$id_usuario]);
if (!$usuario_obj) {
    set_flash('Usuario no encontrado.', 'error');
    redireccionar('/usuarios');
}

// Verificar permiso sobre empresa
if ($usuario_rol_actual === 'admin_empresa' && $usuario_obj['empresa_id'] != $empresa_id_actual) {
    set_flash('No tiene permiso para modificar este usuario.', 'error');
    redireccionar('/usuarios');
}

// Cambiar estado activo/inactivo
$nuevo_estado = $usuario_obj['activo'] ? 0 : 1;

$query_update = "UPDATE usuarios SET activo = ? WHERE id = ?";
$ok = ejecutar_query($query_update, 'ii', [$nuevo_estado, $id_usuario]);

if ($ok) {
    $accion = $nuevo_estado ? 'Usuario reactivado' : 'Usuario desactivado';
    registrar_log_seguridad("$accion: " . $usuario_obj['email'], $_SESSION['usuario_id']);
    set_flash("Usuario {$accion} correctamente", 'success');
} else {
    set_flash('Error al modificar usuario.', 'error');
}

redireccionar('/usuarios');
