<?php
/**
 * Crear Nuevo Usuario Interno
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}
if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

// Sólo superadmin y admin_empresa pueden crear usuarios
if (!in_array($usuario_rol, ['superadmin', 'admin_empresa'])) {
    redireccionar('/dashboard');
}

$error = '';
$exito = '';

// Obtener empresas para superadmin
$empresas = [];
if ($usuario_rol === 'superadmin') {
    $empresas = obtener_filas("SELECT id, nombre FROM empresas WHERE activa = 1 ORDER BY nombre");
} elseif ($usuario_rol === 'admin_empresa') {
    // admin_empresa sólo su empresa
    $query_empresa = "SELECT id, nombre FROM empresas WHERE id = ?";
    $empresas = obtener_filas($query_empresa, 'i', [$empresa_id]);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf = $_POST['csrf_token'] ?? '';
    if (!verificar_csrf_token($csrf)) {
        $error = "Token de seguridad inválido";
    } else {
        $nombre = limpiar_entrada($_POST['nombre'] ?? '');
        $email = limpiar_entrada($_POST['email'] ?? '');
        $rol = limpiar_entrada($_POST['rol'] ?? '');
        $empresa_sel = intval($_POST['empresa_id'] ?? 0);
        $password = $_POST['password'] ?? '';
        $password_conf = $_POST['password_confirm'] ?? '';

        // Validación básica
        if (empty($nombre) || empty($email) || empty($rol) || empty($empresa_sel)) {
            $error = "Todos los campos son obligatorios";
        } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = "Email no válido";
        } elseif ($rol === 'superadmin' && $usuario_rol !== 'superadmin') {
            $error = "No tienes permisos para asignar rol Super Administrador";
        } elseif ($usuario_rol === 'admin_empresa' && $empresa_id !== $empresa_sel) {
            $error = "No tienes permisos para asignar usuarios a otra empresa";
        } elseif ($password !== $password_conf) {
            $error = "Las contraseñas no coinciden";
        } else {
            // Verificar email único
            $existe = obtener_fila("SELECT id FROM usuarios WHERE email = ?", 's', [$email]);
            if ($existe) {
                $error = "El email ya está registrado";
            } else {
                // Insertar
                $pass_hash = hash_password($password);
                $query = "INSERT INTO usuarios (empresa_id, nombre, email, password_hash, rol, activo, fecha_creacion)
                          VALUES (?, ?, ?, ?, ?, 1, NOW())";
                $id = insertar($query, 'issss', [$empresa_sel, $nombre, $email, $pass_hash, $rol]);
                if ($id) {
                    registrar_log_seguridad('Usuario creado: ' . $email, $_SESSION['usuario_id']);
                    set_flash("Usuario creado exitosamente", 'success');
                    redireccionar('/usuarios');
                } else {
                    $error = "Error al crear el usuario";
                }
            }
        }
    }
}

$csrf_token = generar_csrf_token();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Crear Usuario - <?php echo APP_NAME; ?></title>
    <style>
        /* Reutiliza CSS del módulo usuarios para consistencia */
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background: #f5f7fa; color: #333; }
        .navbar { background: white; border-bottom: 1px solid #e1e4e8; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 2px 4px rgb(0 0 0 / 0.05); }
        .navbar-brand { font-size: 18px; font-weight: 600; color: #333; text-decoration: none; }
        .navbar-user { display: flex; align-items: center; gap: 20px; }
        .btn-logout { padding: 8px 16px; background: #dc3545; color: white; border-radius: 4px; font-size: 14px; text-decoration: none; }
        .container { max-width: 600px; margin: 30px auto; padding: 0 30px; }
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 28px; }
        .alert-success { background: #efe; color: #3c3; border: 1px solid #cfc; padding: 10px 15px; border-radius: 6px; margin-bottom: 20px; }
        .alert-error { background: #fee; color: #c33; border: 1px solid #fcc; padding: 10px 15px; border-radius: 6px; margin-bottom: 20px; }
        form { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        label { display: block; margin-bottom: 6px; font-weight: 600; }
        input[type=text], input[type=email], input[type=password], select {
            width: 100%; padding: 10px 12px; margin-bottom: 18px; border: 1px solid #ddd; border-radius: 6px; font-size: 14px; font-family: inherit;
        }
        button { background: #667eea; color: white; border: none; padding: 12px 20px; border-radius: 6px; cursor: pointer; font-size: 16px; font-weight: 600; }
        button:hover { background: #5568d3; }
        a.back-link { display: inline-block; margin-bottom: 25px; color: #667eea; text-decoration: none; font-size: 14px; }
        a.back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="/dashboard" class="navbar-brand"><?php echo APP_NAME; ?></a>
        <div class="navbar-user">
            <span><strong><?php echo htmlspecialchars($_SESSION['usuario_nombre']); ?></strong> (<?php echo ROLES[$_SESSION['usuario_rol']]; ?>)</span>
            <a href="/logout" class="btn-logout">Cerrar Sesión</a>
        </div>
    </nav>
    
    <div class="container">
        <a href="/usuarios" class="back-link">← Volver a Lista de Usuarios</a>
        
        <h1>Crear Nuevo Usuario</h1>
        
        <?php if ($error): ?>
            <div class="alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            
            <label for="nombre">Nombre completo</label>
            <input type="text" id="nombre" name="nombre" required maxlength="255" value="<?php echo htmlspecialchars($_POST['nombre'] ?? ''); ?>">
            
            <label for="email">Correo electrónico</label>
            <input type="email" id="email" name="email" required maxlength="255" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">
            
            <label for="rol">Rol</label>
            <select id="rol" name="rol" required>
                <option value="">Seleccione rol</option>
                <?php foreach ($roles_opciones as $k => $v): ?>
                    <?php
                    // Admin Empresa no puede crear superadmins
                    if ($k == 'superadmin' && $usuario_rol !== 'superadmin') continue;
                    ?>
                    <option value="<?php echo $k; ?>" <?php echo ((isset($_POST['rol']) && $_POST['rol'] == $k) ? 'selected' : ''); ?>>
                        <?php echo $v; ?>
                    </option>
                <?php endforeach; ?>
            </select>
            
            <label for="empresa_id">Empresa</label>
            <select id="empresa_id" name="empresa_id" required>
                <option value="">Seleccione empresa</option>
                <?php foreach ($empresas as $e): ?>
                <option value="<?php echo $e['id']; ?>" <?php echo ((isset($_POST['empresa_id']) && $_POST['empresa_id'] == $e['id']) ? 'selected' : ''); ?>>
                    <?php echo htmlspecialchars($e['nombre']); ?>
                </option>
                <?php endforeach; ?>
            </select>
            
            <label for="password">Contraseña temporal</label>
            <input type="password" id="password" name="password" required minlength="6">
            
            <label for="password_confirm">Confirmar contraseña</label>
            <input type="password" id="password_confirm" name="password_confirm" required minlength="6">
            
            <button type="submit">Crear Usuario</button>
        </form>
    </div>
</body>
</html>
