<?php
/**
 * Dashboard Principal
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

// Verificar sesión
if (!verificar_sesion()) {
    redireccionar('/login');
}

// Obtener datos del usuario
$usuario_id = $_SESSION['usuario_id'];
$usuario_nombre = $_SESSION['usuario_nombre'];
$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

// Construir WHERE según rol
$where_empresa = '';
$params = [];
$types = '';

if ($usuario_rol !== 'superadmin' && $empresa_id) {
    $where_empresa = ' AND c.empresa_id = ?';
    $params[] = $empresa_id;
    $types = 'i';
}

// Estadísticas generales
$stats = [
    'total_casos' => 0,
    'casos_nuevos' => 0,
    'casos_en_proceso' => 0,
    'casos_cerrados_mes' => 0
];

// Total de casos
$query = "SELECT COUNT(*) as total FROM casos c WHERE 1=1 $where_empresa";
$result = obtener_fila($query, $types, $params);
$stats['total_casos'] = $result['total'] ?? 0;

// Casos nuevos (últimos 7 días)
$query = "SELECT COUNT(*) as total FROM casos c 
          WHERE DATE(c.fecha_creacion) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) 
          $where_empresa";
$result = obtener_fila($query, $types, $params);
$stats['casos_nuevos'] = $result['total'] ?? 0;

// Casos en proceso
$query = "SELECT COUNT(*) as total FROM casos c 
          WHERE c.estado IN ('visto', 'asignado', 'en_proceso', 'pendiente_respuesta') 
          $where_empresa";
$result = obtener_fila($query, $types, $params);
$stats['casos_en_proceso'] = $result['total'] ?? 0;

// Casos cerrados este mes
$query = "SELECT COUNT(*) as total FROM casos c 
          WHERE c.estado = 'cerrado' 
          AND YEAR(c.fecha_cierre) = YEAR(CURDATE()) 
          AND MONTH(c.fecha_cierre) = MONTH(CURDATE()) 
          $where_empresa";
$result = obtener_fila($query, $types, $params);
$stats['casos_cerrados_mes'] = $result['total'] ?? 0;

// Últimos 10 casos
$query = "SELECT c.id, c.numero_caso, c.tipo_caso, c.asunto, c.estado, c.prioridad, 
          c.fecha_creacion, cl.nombre as cliente_nombre, e.siglas as empresa_siglas
          FROM casos c
          JOIN clientes cl ON c.cliente_id = cl.id
          JOIN empresas e ON c.empresa_id = e.id
          WHERE 1=1 $where_empresa
          ORDER BY c.fecha_creacion DESC
          LIMIT 10";

$ultimos_casos = obtener_filas($query, $types, $params);

// Obtener empresa del usuario si no es superadmin
$empresa_nombre = 'Todas las empresas';
if ($empresa_id) {
    $query_empresa = "SELECT nombre FROM empresas WHERE id = ?";
    $empresa_data = obtener_fila($query_empresa, 'i', [$empresa_id]);
    $empresa_nombre = $empresa_data['nombre'] ?? 'N/A';
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?php echo APP_NAME; ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif;
            background: #f5f7fa;
            color: #333;
        }
        
        .navbar {
            background: white;
            border-bottom: 1px solid #e1e4e8;
            padding: 15px 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .navbar-brand {
            font-size: 18px;
            font-weight: 600;
            color: #333;
        }
        
        .navbar-user {
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .navbar-user span {
            font-size: 14px;
            color: #666;
        }
        
        .btn-logout {
            padding: 8px 16px;
            background: #dc3545;
            color: white;
            text-decoration: none;
            border-radius: 4px;
            font-size: 14px;
            transition: background 0.3s;
        }
        
        .btn-logout:hover {
            background: #c82333;
        }
        
        .container {
            max-width: 1400px;
            margin: 30px auto;
            padding: 0 30px;
        }
        
        .page-header {
            margin-bottom: 30px;
        }
        
        .page-header h1 {
            font-size: 28px;
            margin-bottom: 8px;
        }
        
        .page-header p {
            color: #666;
            font-size: 14px;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            border-left: 4px solid #667eea;
        }
        
        .stat-card.green {
            border-left-color: #28a745;
        }
        
        .stat-card.orange {
            border-left-color: #fd7e14;
        }
        
        .stat-card.red {
            border-left-color: #dc3545;
        }
        
        .stat-card h3 {
            font-size: 14px;
            font-weight: 500;
            color: #666;
            margin-bottom: 10px;
        }
        
        .stat-card .number {
            font-size: 36px;
            font-weight: 700;
            color: #333;
        }
        
        .card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
            padding: 25px;
        }
        
        .card-header {
            margin-bottom: 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .card-header h2 {
            font-size: 18px;
            font-weight: 600;
        }
        
        .btn {
            padding: 8px 16px;
            border-radius: 4px;
            text-decoration: none;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.3s;
        }
        
        .btn-primary {
            background: #667eea;
            color: white;
        }
        
        .btn-primary:hover {
            background: #5568d3;
        }
        
        .table-responsive {
            overflow-x: auto;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        table th {
            background: #f8f9fa;
            padding: 12px;
            text-align: left;
            font-size: 13px;
            font-weight: 600;
            color: #666;
            border-bottom: 2px solid #e1e4e8;
        }
        
        table td {
            padding: 12px;
            border-bottom: 1px solid #e1e4e8;
            font-size: 14px;
        }
        
        table tr:hover {
            background: #f8f9fa;
        }
        
        .badge {
            display: inline-block;
            padding: 4px 10px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
        }
        
        .badge-nuevo {
            background: #e3f2fd;
            color: #1976d2;
        }
        
        .badge-visto {
            background: #f3e5f5;
            color: #7b1fa2;
        }
        
        .badge-asignado {
            background: #fff3e0;
            color: #f57c00;
        }
        
        .badge-proceso {
            background: #e8f5e9;
            color: #388e3c;
        }
        
        .badge-cerrado {
            background: #e0e0e0;
            color: #616161;
        }
        
        .badge-urgente {
            background: #ffebee;
            color: #c62828;
        }
        
        .badge-alta {
            background: #fff3e0;
            color: #ef6c00;
        }
        
        .badge-media {
            background: #fff9c4;
            color: #f9a825;
        }
        
        .badge-baja {
            background: #e8f5e9;
            color: #43a047;
        }
        
        .empty-state {
            text-align: center;
            padding: 40px;
            color: #999;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="navbar-brand"><?php echo APP_NAME; ?></div>
        <div class="navbar-user">
            <span><strong><?php echo htmlspecialchars($usuario_nombre); ?></strong> (<?php echo htmlspecialchars(ROLES[$usuario_rol]); ?>)</span>
            <a href="/logout" class="btn-logout">Cerrar Sesión</a>
        </div>
    </nav>
    
    <div class="container">
        <div class="page-header">
            <h1>Dashboard</h1>
            <p><?php echo htmlspecialchars($empresa_nombre); ?> • <?php echo date('d/m/Y H:i'); ?></p>
        </div>
        
        <div class="stats-grid">
            <div class="stat-card">
                <h3>Total de Casos</h3>
                <div class="number"><?php echo number_format($stats['total_casos']); ?></div>
            </div>
            
            <div class="stat-card green">
                <h3>Casos Nuevos (7 días)</h3>
                <div class="number"><?php echo number_format($stats['casos_nuevos']); ?></div>
            </div>
            
            <div class="stat-card orange">
                <h3>En Proceso</h3>
                <div class="number"><?php echo number_format($stats['casos_en_proceso']); ?></div>
            </div>
            
            <div class="stat-card red">
                <h3>Cerrados Este Mes</h3>
                <div class="number"><?php echo number_format($stats['casos_cerrados_mes']); ?></div>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h2>Últimos Casos</h2>
                <a href="/casos" class="btn btn-primary">Ver Todos los Casos</a>
            </div>
            
            <?php if (empty($ultimos_casos)): ?>
                <div class="empty-state">
                    <p>No hay casos registrados</p>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table>
                        <thead>
                            <tr>
                                <th>N° Caso</th>
                                <th>Tipo</th>
                                <th>Asunto</th>
                                <th>Cliente</th>
                                <th>Estado</th>
                                <th>Prioridad</th>
                                <th>Fecha</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($ultimos_casos as $caso): ?>
                                <tr onclick="window.location='/casos/detalle/<?php echo $caso['id']; ?>'" style="cursor: pointer;">
                                    <td><strong><?php echo htmlspecialchars($caso['numero_caso']); ?></strong></td>
                                    <td><?php echo ucfirst(htmlspecialchars($caso['tipo_caso'])); ?></td>
                                    <td><?php echo htmlspecialchars(substr($caso['asunto'], 0, 50)) . (strlen($caso['asunto']) > 50 ? '...' : ''); ?></td>
                                    <td><?php echo htmlspecialchars($caso['cliente_nombre']); ?></td>
                                    <td>
                                        <span class="badge badge-<?php echo $caso['estado']; ?>">
                                            <?php echo ESTADOS_CASO[$caso['estado']]; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <span class="badge badge-<?php echo $caso['prioridad']; ?>">
                                            <?php echo PRIORIDADES_CASO[$caso['prioridad']]; ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('d/m/Y H:i', strtotime($caso['fecha_creacion'])); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
