<?php
/**
 * Activar/Desactivar Feriado
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}
if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

if (!in_array($usuario_rol, ['superadmin', 'admin_empresa'])) {
    redireccionar('/dashboard');
}

$id_feriado = intval($_GET['id'] ?? 0);
if ($id_feriado <= 0) {
    redireccionar('/configuracion/listar_feriados');
}

$feriado = obtener_fila("SELECT * FROM feriados WHERE id = ?", 'i', [$id_feriado]);
if (!$feriado) {
    set_flash('Feriado no encontrado.', 'error');
    redireccionar('/configuracion/listar_feriados');
}

// Validar acceso empresa para admin_empresa
if ($usuario_rol === 'admin_empresa' && $feriado['empresa_id'] != $empresa_id) {
    set_flash('No tiene permiso para modificar este feriado.', 'error');
    redireccionar('/configuracion/listar_feriados');
}

$nuevo_estado = $feriado['activo'] ? 0 : 1;

$ok = ejecutar_query("UPDATE feriados SET activo = ? WHERE id = ?", 'ii', [$nuevo_estado, $id_feriado]);

if ($ok) {
    $accion = $nuevo_estado ? 'Feriado reactivado' : 'Feriado desactivado';
    registrar_log_seguridad($accion . ': ' . $feriado['descripcion'], $_SESSION['usuario_id']);
    set_flash("Feriado {$accion} correctamente", 'success');
} else {
    set_flash('Error al modificar feriado.', 'error');
}

redireccionar('/configuracion/listar_feriados');
