<?php
/**
 * Crear / Editar Feriado
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}
if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

if (!in_array($usuario_rol, ['superadmin', 'admin_empresa'])) {
    redireccionar('/dashboard');
}

$id_feriado = intval($_GET['id'] ?? 0);

$error = '';
$exito = '';

$feriado = null;

if ($id_feriado > 0) {
    $feriado = obtener_fila("SELECT * FROM feriados WHERE id = ?", 'i', [$id_feriado]);
    if (!$feriado) {
        set_flash('Feriado no encontrado', 'error');
        redireccionar('/configuracion/listar_feriados');
    }
}

// Empresas para selección
$empresas = [];
if ($usuario_rol === 'superadmin') {
    $empresas = obtener_filas("SELECT id, nombre FROM empresas WHERE activa = 1 ORDER BY nombre");
} elseif ($usuario_rol === 'admin_empresa') {
    $empresas = obtener_filas("SELECT id, nombre FROM empresas WHERE id = ?", 'i', [$empresa_id]);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf_token = $_POST['csrf_token'] ?? '';
    if (!verificar_csrf_token($csrf_token)) {
        $error = 'Token de seguridad inválido';
    } else {
        $empresa_sel = intval($_POST['empresa_id'] ?? 0);
        $fecha = $_POST['fecha'] ?? '';
        $descripcion = limpiar_entrada($_POST['descripcion'] ?? '');
        $activo = isset($_POST['activo']) ? 1 : 0;

        if ($empresa_sel <= 0) {
            $error = 'Debe seleccionar una empresa';
        } elseif (empty($fecha)) {
            $error = 'Debe ingresar la fecha';
        } elseif (empty($descripcion)) {
            $error = 'Debe ingresar la descripción';
        } else {
            if ($usuario_rol === 'admin_empresa' && $empresa_sel != $empresa_id) {
                $error = 'No tiene permiso para asignar a otra empresa';
            } else {
                if ($id_feriado > 0) {
                    // Actualizar
                    $query = "UPDATE feriados SET empresa_id = ?, fecha = ?, descripcion = ?, activo = ? WHERE id = ?";
                    $ok = ejecutar_query($query, 'issii', [$empresa_sel, $fecha, $descripcion, $activo, $id_feriado]);
                    if ($ok) {
                        registrar_log_seguridad("Feriado editado: $descripcion", $_SESSION['usuario_id']);
                        set_flash('Feriado actualizado correctamente', 'success');
                        redireccionar('/configuracion/listar_feriados');
                    } else {
                        $error = 'Error al actualizar feriado';
                    }
                } else {
                    // Crear
                    $query = "INSERT INTO feriados (empresa_id, fecha, descripcion, activo) VALUES (?, ?, ?, ?)";
                    $nuevo_id = insertar($query, 'issi', [$empresa_sel, $fecha, $descripcion, $activo]);
                    if ($nuevo_id) {
                        registrar_log_seguridad("Feriado creado: $descripcion", $_SESSION['usuario_id']);
                        set_flash('Feriado creado correctamente', 'success');
                        redireccionar('/configuracion/listar_feriados');
                    } else {
                        $error = 'Error al crear feriado';
                    }
                }
            }
        }
    }
}

$csrf_token = generar_csrf_token();
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<title><?php echo $id_feriado ? 'Editar' : 'Crear'; ?> Feriado - <?php echo APP_NAME; ?></title>
<style>
    /* Estilo uniforme */
    body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background:#f5f7fa; color:#333; }
    .navbar { background:white; border-bottom:1px solid #e1e4e8; padding: 15px 30px; display:flex; justify-content:space-between; align-items:center; box-shadow:0 2px 4px rgb(0 0 0 / 0.05);}
    .navbar-brand { font-size:18px; font-weight:600; color:#333; text-decoration:none; }
    .navbar-user { display:flex; align-items:center; gap: 20px; }
    .btn-logout { padding:8px 16px; background:#dc3545; color:white; border-radius:4px; font-size:14px; text-decoration:none; }
    .container { max-width:600px; margin: 30px auto; padding: 0 30px; }
    .page-header { margin-bottom: 30px; }
    .page-header h1 { font-size: 28px; }
    form { background:white; padding:30px; border-radius:8px; box-shadow:0 2px 4px rgb(0 0 0 / 0.05); }
    label { display:block; margin-bottom:6px; font-weight:600; }
    input[type=text], input[type=date], select {
        width: 100%; padding: 10px 12px; margin-bottom: 18px; border: 1px solid #ddd; border-radius: 6px; font-size: 14px; font-family: inherit;
    }
    button { background: #667eea; color: white; border: none; padding: 12px 20px; border-radius: 6px; cursor: pointer; font-size: 16px; font-weight: 600; }
    button:hover { background: #5568d3; }
    a.back-link { display: inline-block; margin-bottom: 25px; color: #667eea; text-decoration: none; }
    a.back-link:hover { text-decoration: underline; }
    .checkbox-group { display: flex; align-items: center; gap: 10px; margin-bottom: 16px; }
    .checkbox-group input { width: auto; }
    .alert-success { background: #efe; color: #3c3; border: 1px solid #cfc; padding: 10px 15px; border-radius: 6px; margin-bottom: 20px; }
    .alert-error { background: #fee; color: #c33; border: 1px solid #fcc; padding: 10px 15px; border-radius: 6px; margin-bottom: 20px; }
</style>
</head>
<body>
<nav class="navbar">
    <a href="/dashboard" class="navbar-brand"><?php echo APP_NAME; ?></a>
    <div class="navbar-user">
        <span><strong><?php echo htmlspecialchars($_SESSION['usuario_nombre']); ?></strong> (<?php echo ROLES[$_SESSION['usuario_rol']]; ?>)</span>
        <a href="/logout" class="btn-logout">Cerrar Sesión</a>
    </div>
</nav>
<div class="container">
    <a href="/configuracion/listar_feriados" class="back-link">← Volver a lista de feriados</a>
    <h1><?php echo $id_feriado ? 'Editar' : 'Crear'; ?> Feriado</h1>
    
    <?php if ($error): ?>
        <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
    <?php endif; ?>
    
    <form method="POST" action="">
        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
        
        <label for="empresa_id">Empresa</label>
        <select id="empresa_id" name="empresa_id" required>
            <option value="">Seleccione empresa</option>
            <?php foreach ($empresas as $empresa): ?>
            <option value="<?php echo $empresa['id']; ?>" <?php echo ((isset($_POST['empresa_id']) && $_POST['empresa_id'] == $empresa['id']) || (!isset($_POST['empresa_id']) && $feriado['empresa_id'] == $empresa['id'])) ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($empresa['nombre']); ?>
            </option>
            <?php endforeach; ?>
        </select>
        
        <label for="fecha">Fecha</label>
        <input type="date" id="fecha" name="fecha" required value="<?php echo htmlspecialchars($_POST['fecha'] ?? $feriado['fecha'] ?? ''); ?>">
        
        <label for="descripcion">Descripción</label>
        <input type="text" id="descripcion" name="descripcion" required maxlength="255" value="<?php echo htmlspecialchars($_POST['descripcion'] ?? $feriado['descripcion'] ?? ''); ?>">
        
        <div class="checkbox-group">
            <input type="checkbox" id="activo" name="activo" <?php echo ((isset($_POST['activo']) && $_POST['activo']) || (!isset($_POST['activo']) && ($feriado['activo'] ?? true))) ? 'checked' : ''; ?>>
            <label for="activo">Activo</label>
        </div>
        
        <button type="submit"><?php echo $id_feriado ? 'Guardar Cambios' : 'Crear Feriado'; ?></button>
    </form>
</div>
</body>
</html>
