<?php
/**
 * Crear / Editar Empresa
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_rol = $_SESSION['usuario_rol'];

if ($usuario_rol !== 'superadmin') {
    redireccionar('/dashboard');
}

$id_empresa = intval($_GET['id'] ?? 0);

$error = '';
$exito = '';

$empresa = null;

if ($id_empresa > 0) {
    $empresa = obtener_fila("SELECT * FROM empresas WHERE id = ?", 'i', [$id_empresa]);
    if (!$empresa) {
        set_flash('Empresa no encontrada.', 'error');
        redireccionar('/configuracion/listar_empresas');
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf_token = $_POST['csrf_token'] ?? '';
    if (!verificar_csrf_token($csrf_token)) {
        $error = "Token de seguridad inválido";
    } else {
        $nombre = limpiar_entrada($_POST['nombre'] ?? '');
        $siglas = limpiar_entrada($_POST['siglas'] ?? '');
        $activo = isset($_POST['activo']) ? 1 : 0;

        if (empty($nombre)) {
            $error = "El nombre es obligatorio";
        } elseif (empty($siglas)) {
            $error = "Las siglas son obligatorias";
        } else {
            if ($id_empresa > 0) {
                // Actualizar
                $query = "UPDATE empresas SET nombre = ?, siglas = ?, activo = ? WHERE id = ?";
                $ok = ejecutar_query($query, 'ssii', [$nombre, $siglas, $activo, $id_empresa]);
                if ($ok) {
                    registrar_log_seguridad("Empresa editada: $nombre", $_SESSION['usuario_id']);
                    set_flash("Empresa actualizada correctamente", "success");
                    redireccionar('/configuracion/listar_empresas');
                } else {
                    $error = "Error al actualizar empresa";
                }
            } else {
                // Crear nueva
                $query = "INSERT INTO empresas (nombre, siglas, activo) VALUES (?, ?, ?)";
                $nuevo_id = insertar($query, 'ssi', [$nombre, $siglas, $activo]);
                if ($nuevo_id) {
                    registrar_log_seguridad("Empresa creada: $nombre", $_SESSION['usuario_id']);
                    set_flash("Empresa creada correctamente", "success");
                    redireccionar('/configuracion/listar_empresas');
                } else {
                    $error = "Error al crear empresa";
                }
            }
        }
    }
}

$csrf_token = generar_csrf_token();

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title><?php echo $id_empresa ? 'Editar' : 'Crear'; ?> Empresa - <?php echo APP_NAME; ?></title>
    <style>
        /* Diseño coherente */
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background:#f5f7fa; color:#333; }
        .navbar { background:white; border-bottom:1px solid #e1e4e8; padding: 15px 30px; display:flex; justify-content:space-between; align-items:center; box-shadow:0 2px 4px rgb(0 0 0 / 0.05);}
        .navbar-brand { font-size:18px; font-weight:600; color:#333; text-decoration:none; }
        .navbar-user { display:flex; align-items:center; gap: 20px; }
        .btn-logout { padding:8px 16px; background:#dc3545; color:white; border-radius:4px; font-size:14px; text-decoration:none; }
        .container { max-width:600px; margin: 30px auto; padding: 0 30px; }
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 28px; }
        form { background:white; padding:30px; border-radius:8px; box-shadow:0 2px 4px rgb(0 0 0 / 0.05); }
        label { display:block; margin-bottom:6px; font-weight:600; }
        input[type=text] { width: 100%; padding: 10px 12px; margin-bottom:18px; border:1px solid #ddd; border-radius: 6px; font-size:14px; font-family:inherit; }
        button { background: #667eea; color:white; border:none; padding:12px 20px; border-radius:6px; cursor:pointer; font-size:16px; font-weight:600; }
        button:hover{background:#5568d3;}
        a.back-link { display:inline-block; margin-bottom:25px; color:#667eea; text-decoration:none; }
        a.back-link:hover { text-decoration:underline; }
        .checkbox-group { display:flex; align-items:center; gap:10px; margin-bottom:16px; }
        .checkbox-group input { width:auto; }
        .alert-success { background:#efe; color:#3c3; border:1px solid #cfc; padding:10px 15px; border-radius:6px; margin-bottom:20px; }
        .alert-error { background:#fee; color:#c33; border:1px solid #fcc; padding:10px 15px; border-radius:6px; margin-bottom:20px; }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="/dashboard" class="navbar-brand"><?php echo APP_NAME; ?></a>
        <div class="navbar-user">
            <span><strong><?php echo htmlspecialchars($_SESSION['usuario_nombre']); ?></strong> (<?php echo ROLES[$_SESSION['usuario_rol']]; ?>)</span>
            <a href="/logout" class="btn-logout">Cerrar Sesión</a>
        </div>
    </nav>
    <div class="container">
        <a href="/configuracion/listar_empresas" class="back-link">← Volver a listado de empresas</a>
        <h1><?php echo $id_empresa ? 'Editar' : 'Crear'; ?> Empresa</h1>
        
        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">

            <label for="nombre">Nombre</label>
            <input type="text" id="nombre" name="nombre" required maxlength="255" value="<?php echo htmlspecialchars($_POST['nombre'] ?? $empresa['nombre'] ?? ''); ?>">

            <label for="siglas">Siglas</label>
            <input type="text" id="siglas" name="siglas" required maxlength="10" value="<?php echo htmlspecialchars($_POST['siglas'] ?? $empresa['siglas'] ?? ''); ?>">

            <div class="checkbox-group">
                <input type="checkbox" id="activo" name="activo" <?php echo ((isset($_POST['activo']) && $_POST['activo']) || (!isset($_POST['activo']) && ($empresa['activo'] ?? true))) ? 'checked' : ''; ?>>
                <label for="activo">Activo</label>
            </div>

            <button type="submit"><?php echo $id_empresa ? 'Guardar Cambios' : 'Crear Empresa'; ?></button>
        </form>
    </div>
</body>
</html>
