<?php
/**
 * Activar/Desactivar Cliente
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_rol_actual = $_SESSION['usuario_rol'];
$empresa_id_actual = $_SESSION['empresa_id'];

if (!in_array($usuario_rol_actual, ['superadmin', 'admin_empresa'])) {
    redireccionar('/dashboard');
}

$id_cliente = intval($_GET['id'] ?? 0);
if ($id_cliente <= 0) {
    redireccionar('/clientes');
}

// Obtener datos del cliente a modificar
$query = "SELECT * FROM clientes WHERE id = ?";
$cliente = obtener_fila($query, 'i', [$id_cliente]);
if (!$cliente) {
    set_flash('Cliente no encontrado.', 'error');
    redireccionar('/clientes');
}

// Validar acceso según empresa
if ($usuario_rol_actual === 'admin_empresa' && $cliente['empresa_id'] != $empresa_id_actual) {
    set_flash('No tiene permiso para modificar este cliente.', 'error');
    redireccionar('/clientes');
}

$nuevo_estado = $cliente['activo'] ? 0 : 1;

$query_update = "UPDATE clientes SET activo = ? WHERE id = ?";
$ok = ejecutar_query($query_update, 'ii', [$nuevo_estado, $id_cliente]);

if ($ok) {
    $accion = $nuevo_estado ? 'Cliente reactivado' : 'Cliente desactivado';
    registrar_log_seguridad("$accion: " . $cliente['nombre'], $_SESSION['usuario_id']);
    set_flash("Cliente {$accion} correctamente", 'success');
} else {
    set_flash('Error al modificar cliente.', 'error');
}

redireccionar('/clientes');
