<?php
/**
 * Crear Nuevo Cliente
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}
if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

if (!in_array($usuario_rol, ['admin_empresa', 'superadmin'])) {
    redireccionar('/dashboard');
}

$error = '';
$exito = '';

// Obtener empresas para superadmin
$empresas = [];
if ($usuario_rol === 'superadmin') {
    $empresas = obtener_filas("SELECT id, nombre FROM empresas WHERE activa = 1 ORDER BY nombre");
} elseif ($usuario_rol === 'admin_empresa') {
    $empresas = obtener_filas("SELECT id, nombre FROM empresas WHERE id = ?", 'i', [$empresa_id]);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf_token = $_POST['csrf_token'] ?? '';
    
    if (!verificar_csrf_token($csrf_token)) {
        $error = 'Token de seguridad inválido';
    } else {
        $empresa_sel = intval($_POST['empresa_id'] ?? 0);
        $rut = limpiar_entrada($_POST['rut'] ?? '');
        $nombre = limpiar_entrada($_POST['nombre'] ?? '');
        $email = limpiar_entrada($_POST['email'] ?? '');
        $telefono = limpiar_entrada($_POST['telefono'] ?? '');
        $activo = isset($_POST['activo']) ? 1 : 0;
        
        if ($empresa_sel <= 0) {
            $error = 'Debe seleccionar una empresa';
        } elseif (empty($rut)) {
            $error = 'Debe ingresar el RUT';
        } elseif (!validar_rut($rut)) {
            $error = 'RUT inválido';
        } elseif (empty($nombre)) {
            $error = 'Debe ingresar el nombre del cliente';
        } elseif (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $error = 'Email no válido';
        } else {
            // Validaciones de permisos empresa
            if ($usuario_rol === 'admin_empresa' && $empresa_sel != $empresa_id) {
                $error = 'No tiene permiso para asignar cliente a otra empresa';
            } else {
                // Verificar si hay cliente duplicado con mismo RUT en esa empresa
                $duplicado = obtener_fila("SELECT id FROM clientes WHERE empresa_id = ? AND rut = ?", 'is', [$empresa_sel, $rut]);
                
                if ($duplicado) {
                    $error = 'Ya existe un cliente con ese RUT en la empresa seleccionada';
                } else {
                    $query = "INSERT INTO clientes (empresa_id, rut, nombre, email, telefono, activo, metodo_activacion, consentimiento_datos, fecha_consentimiento) 
                              VALUES (?, ?, ?, ?, ?, ?, 'manual', 1, NOW())";
                    $cliente_id = insertar($query, 'issssi', [$empresa_sel, $rut, $nombre, $email, $telefono, $activo]);
                    
                    if ($cliente_id) {
                        registrar_log_seguridad('Cliente creado: ' . $nombre, $_SESSION['usuario_id']);
                        set_flash('Cliente creado correctamente', 'success');
                        redireccionar('/clientes');
                    } else {
                        $error = 'Error al crear el cliente';
                    }
                }
            }
        }
    }
}
$csrf_token = generar_csrf_token();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Crear Cliente - <?php echo APP_NAME; ?></title>
    <style>
        /* Consistente con otros módulos */
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background: #f5f7fa; color: #333; }
        .navbar { background: white; border-bottom: 1px solid #e1e4e8; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 2px 4px rgb(0 0 0 / 0.05); }
        .navbar-brand { font-size: 18px; font-weight: 600; color: #333; text-decoration: none; }
        .navbar-user { display: flex; align-items: center; gap: 20px; }
        .btn-logout { padding: 8px 16px; background: #dc3545; color: white; border-radius: 4px; font-size: 14px; text-decoration: none; }
        .container { max-width: 600px; margin: 30px auto; padding: 0 30px; }
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 28px; }
        form { background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgb(0 0 0 / 0.05); }
        label { display: block; margin-bottom: 6px; font-weight: 600; }
        input[type=text], input[type=email], select {
            width: 100%; padding: 10px 12px; margin-bottom: 18px; border: 1px solid #ddd; border-radius: 6px; font-size: 14px; font-family: inherit;
        }
        button { background: #667eea; color: white; border: none; padding: 12px 20px; border-radius: 6px; cursor: pointer; font-size: 16px; font-weight: 600; }
        button:hover { background: #5568d3; }
        a.back-link { display: inline-block; margin-bottom: 25px; color: #667eea; text-decoration: none; }
        a.back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="/dashboard" class="navbar-brand"><?php echo APP_NAME; ?></a>
        <div class="navbar-user">
            <span><strong><?php echo htmlspecialchars($_SESSION['usuario_nombre']); ?></strong> (<?php echo ROLES[$_SESSION['usuario_rol']]; ?>)</span>
            <a href="/logout" class="btn-logout">Cerrar Sesión</a>
        </div>
    </nav>
    <div class="container">
        <a href="/clientes" class="back-link">← Volver a lista de clientes</a>
        <h1>Crear Nuevo Cliente</h1>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">

            <label for="empresa_id">Empresa</label>
            <select id="empresa_id" name="empresa_id" required>
                <option value="">Seleccione empresa</option>
                <?php foreach ($empresas as $empresa): ?>
                <option value="<?php echo $empresa['id']; ?>" <?php echo (isset($_POST['empresa_id']) && $_POST['empresa_id'] == $empresa['id']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($empresa['nombre']); ?>
                </option>
                <?php endforeach; ?>
            </select>

            <label for="rut">RUT</label>
            <input type="text" id="rut" name="rut" required maxlength="12" placeholder="12.345.678-9"
                   pattern="[0-9.\-Kk]+" title="Formato: 12.345.678-9"
                   value="<?php echo htmlspecialchars($_POST['rut'] ?? ''); ?>">

            <label for="nombre">Nombre Completo</label>
            <input type="text" id="nombre" name="nombre" required maxlength="255" value="<?php echo htmlspecialchars($_POST['nombre'] ?? ''); ?>">

            <label for="email">Email</label>
            <input type="email" id="email" name="email" maxlength="255" placeholder="correo@ejemplo.com" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>">

            <label for="telefono">Teléfono</label>
            <input type="text" id="telefono" name="telefono" maxlength="20" placeholder="+56 9 1234 5678" value="<?php echo htmlspecialchars($_POST['telefono'] ?? ''); ?>">

            <div class="checkbox-group">
                <input type="checkbox" id="activo" name="activo" <?php echo isset($_POST['activo']) ? 'checked' : ''; ?>>
                <label for="activo">Activo</label>
            </div>

            <button type="submit">Crear Cliente</button>
        </form>
    </div>
</body>
</html>
