<?php
/**
 * Responder Caso
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_id = $_SESSION['usuario_id'];
$usuario_nombre = $_SESSION['usuario_nombre'];
$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

$caso_id = intval($_GET['id'] ?? 0);

if (!$caso_id) {
    redireccionar('/casos');
}

// Obtener caso
$query = "SELECT c.*, 
          cl.nombre as cliente_nombre, cl.email as cliente_email,
          e.nombre as empresa_nombre, e.requiere_aprobacion_respuesta
          FROM casos c
          JOIN clientes cl ON c.cliente_id = cl.id
          JOIN empresas e ON c.empresa_id = e.id
          WHERE c.id = ?";

$caso = obtener_fila($query, 'i', [$caso_id]);

if (!$caso) {
    redireccionar('/casos');
}

// Verificar acceso
if ($usuario_rol !== 'superadmin' && $caso['empresa_id'] != $empresa_id) {
    redireccionar('/casos');
}

// Verificar que no esté cerrado
if ($caso['estado'] === 'cerrado') {
    redireccionar('/casos/detalle/' . $caso_id);
}

$error = '';
$exito = '';

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $csrf_token = $_POST['csrf_token'] ?? '';
    
    if (!verificar_csrf_token($csrf_token)) {
        $error = 'Token de seguridad inválido';
    } else {
        $contenido_respuesta = trim($_POST['contenido_respuesta'] ?? '');
        $cerrar_caso = isset($_POST['cerrar_caso']);
        
        if (empty($contenido_respuesta)) {
            $error = 'Debe ingresar una respuesta';
        } else {
            $db = obtener_conexion();
            $db->begin_transaction();
            
            try {
                // Determinar si requiere aprobación
                $requiere_aprobacion = ($caso['requiere_aprobacion_respuesta'] == 1);
                $estado_respuesta = $requiere_aprobacion ? 'pendiente_aprobacion' : 'enviado';
                
                // Insertar respuesta
                $query_respuesta = "INSERT INTO respuestas (caso_id, usuario_id, contenido_respuesta, estado, requiere_aprobacion, enviado_cliente, fecha_respuesta) 
                                   VALUES (?, ?, ?, ?, ?, ?, NOW())";
                
                $enviado_cliente = $requiere_aprobacion ? 0 : 1;
                
                $respuesta_id = insertar($query_respuesta, 'iissii', [
                    $caso_id,
                    $usuario_id,
                    $contenido_respuesta,
                    $estado_respuesta,
                    $requiere_aprobacion ? 1 : 0,
                    $enviado_cliente
                ]);
                
                if (!$respuesta_id) {
                    throw new Exception('Error al guardar la respuesta');
                }
                
                // Actualizar estado del caso
                if ($cerrar_caso) {
                    $nuevo_estado = 'cerrado';
                    $query_caso = "UPDATE casos SET estado = ?, fecha_respuesta = NOW(), fecha_cierre = NOW() WHERE id = ?";
                } else {
                    $nuevo_estado = $requiere_aprobacion ? 'pendiente_aprobacion' : 'respondido';
                    $query_caso = "UPDATE casos SET estado = ?, fecha_respuesta = NOW() WHERE id = ?";
                }
                
                ejecutar_query($query_caso, 'si', [$nuevo_estado, $caso_id]);
                
                // Registrar en historial
                $desc_historial = "Respuesta agregada por " . $usuario_nombre;
                if ($cerrar_caso) {
                    $desc_historial .= " y caso cerrado";
                }
                registrar_historial($caso_id, $usuario_id, 'Respuesta agregada', $desc_historial);
                
                // Log de seguridad
                registrar_log_seguridad('Respuesta agregada a caso: ' . $caso['numero_caso'], $usuario_id, [
                    'caso_id' => $caso_id,
                    'respuesta_id' => $respuesta_id,
                    'cerrado' => $cerrar_caso
                ]);
                
                $db->commit();

                // Enviar notificaciones email

                // Notificar admins de empresa
                $admins = obtener_filas(
                    "SELECT email FROM usuarios WHERE empresa_id = ? AND activo = 1 AND rol IN ('admin_empresa', 'superadmin')",
                    'i', [$caso['empresa_id']]
                );

                $cliente_email = $caso['cliente_email'] ?? '';

                $asunto_mail = "Respuesta a Reclamo: " . $caso['numero_caso'];
                $mensaje_mail = "<h3>Respuesta nueva a su reclamo</h3>";
                $mensaje_mail .= "<p><strong>Número de caso:</strong> " . htmlspecialchars($caso['numero_caso']) . "</p>";
                $mensaje_mail .= "<p><strong>Asunto:</strong> " . htmlspecialchars($caso['asunto']) . "</p>";
                $mensaje_mail .= "<p>Por favor, revise el portal para detalles adicionales.</p>";

                foreach ($admins as $admin) {
                    enviar_email($admin['email'], $asunto_mail, $mensaje_mail);
                }

                if (!empty($cliente_email)) {
                    enviar_email($cliente_email, $asunto_mail, $mensaje_mail);
                }
                
                redireccionar('/casos/detalle/' . $caso_id);
                
            } catch (Exception $e) {
                $db->rollback();
                $error = 'Error al guardar la respuesta: ' . $e->getMessage();
                error_log("Error guardando respuesta: " . $e->getMessage());
            }
        }
    }
}

$csrf_token = generar_csrf_token();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Responder Caso <?php echo htmlspecialchars($caso['numero_caso']); ?> - <?php echo APP_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: #f5f7fa; color: #333; }
        .navbar { background: white; border-bottom: 1px solid #e1e4e8; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        .navbar-brand { font-size: 18px; font-weight: 600; color: #333; text-decoration: none; }
        .navbar-user { display: flex; align-items: center; gap: 20px; }
        .btn-logout { padding: 8px 16px; background: #dc3545; color: white; text-decoration: none; border-radius: 4px; font-size: 14px; }
        .container { max-width: 1000px; margin: 30px auto; padding: 0 30px; }
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 28px; margin-bottom: 10px; }
        .back-link { color: #667eea; text-decoration: none; font-size: 14px; }
        .back-link:hover { text-decoration: underline; }
        .card { background: white; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); padding: 30px; margin-bottom: 20px; }
        .alert { padding: 12px 15px; border-radius: 6px; margin-bottom: 20px; font-size: 14px; }
        .alert-error { background: #fee; color: #c33; border: 1px solid #fcc; }
        .alert-success { background: #efe; color: #3c3; border: 1px solid #cfc; }
        .alert-info { background: #e7f3ff; color: #0066cc; border: 1px solid #b3d9ff; }
        .caso-info { background: #f8f9fa; padding: 20px; border-radius: 6px; margin-bottom: 30px; }
        .caso-info h3 { font-size: 16px; margin-bottom: 10px; }
        .caso-info p { margin-bottom: 8px; font-size: 14px; line-height: 1.6; }
        .form-group { margin-bottom: 25px; }
        .form-group label { display: block; margin-bottom: 8px; font-size: 14px; font-weight: 500; color: #333; }
        .form-group textarea { width: 100%; padding: 12px 15px; border: 1px solid #ddd; border-radius: 6px; font-size: 14px; font-family: inherit; min-height: 200px; resize: vertical; }
        .form-group textarea:focus { outline: none; border-color: #667eea; }
        .checkbox-group { display: flex; align-items: center; gap: 10px; padding: 15px; background: #fff9e6; border-radius: 6px; border: 1px solid #ffd54f; }
        .checkbox-group input[type="checkbox"] { width: 20px; height: 20px; cursor: pointer; }
        .checkbox-group label { margin: 0; cursor: pointer; font-weight: normal; }
        .form-actions { display: flex; gap: 10px; justify-content: flex-end; margin-top: 30px; padding-top: 20px; border-top: 1px solid #f0f0f0; }
        .btn { padding: 12px 24px; border-radius: 6px; text-decoration: none; font-size: 14px; font-weight: 500; border: none; cursor: pointer; transition: all 0.3s; display: inline-block; }
        .btn-primary { background: #667eea; color: white; }
        .btn-primary:hover { background: #5568d3; }
        .btn-secondary { background: #6c757d; color: white; }
        .btn-secondary:hover { background: #5a6268; }
        .help-text { font-size: 13px; color: #666; margin-top: 8px; line-height: 1.5; }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="/dashboard" class="navbar-brand"><?php echo APP_NAME; ?></a>
        <div class="navbar-user">
            <span><strong><?php echo htmlspecialchars($usuario_nombre); ?></strong> (<?php echo ROLES[$usuario_rol]; ?>)</span>
            <a href="/logout" class="btn-logout">Cerrar Sesión</a>
        </div>
    </nav>
    
    <div class="container">
        <div class="page-header">
            <a href="/casos/detalle/<?php echo $caso_id; ?>" class="back-link">← Volver al Detalle del Caso</a>
            <h1>Responder Caso <?php echo htmlspecialchars($caso['numero_caso']); ?></h1>
        </div>
        
        <div class="card">
            <?php if ($error): ?>
                <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <?php if ($exito): ?>
                <div class="alert alert-success"><?php echo htmlspecialchars($exito); ?></div>
            <?php endif; ?>
            
            <?php if ($caso['requiere_aprobacion_respuesta']): ?>
                <div class="alert alert-info">
                    <strong>Nota:</strong> Esta empresa requiere aprobación de respuestas. Tu respuesta quedará pendiente de aprobación antes de ser enviada al cliente.
                </div>
            <?php endif; ?>
            
            <!-- Información del caso -->
            <div class="caso-info">
                <h3>Información del Caso</h3>
                <p><strong>Cliente:</strong> <?php echo htmlspecialchars($caso['cliente_nombre']); ?></p>
                <?php if ($caso['cliente_email']): ?>
                    <p><strong>Email:</strong> <?php echo htmlspecialchars($caso['cliente_email']); ?></p>
                <?php endif; ?>
                <p><strong>Asunto:</strong> <?php echo htmlspecialchars($caso['asunto']); ?></p>
                <p><strong>Descripción:</strong></p>
                <p style="margin-left: 15px; font-style: italic;">
                    <?php echo nl2br(htmlspecialchars(substr($caso['descripcion'], 0, 300))); ?>
                    <?php if (strlen($caso['descripcion']) > 300): ?>
                        ... <a href="/casos/detalle/<?php echo $caso_id; ?>">Ver más</a>
                    <?php endif; ?>
                </p>
            </div>
            
            <!-- Formulario de respuesta -->
            <form method="POST" action="">
                <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                
                <div class="form-group">
                    <label>Respuesta al Cliente <span class="required">*</span></label>
                    <textarea name="contenido_respuesta" required 
                              placeholder="Escriba aquí la respuesta detallada para el cliente..."></textarea>
                    <div class="help-text">
                        Redacte una respuesta clara y profesional. Incluya toda la información relevante y las acciones tomadas o por tomar.
                    </div>
                </div>
                
                <div class="checkbox-group">
                    <input type="checkbox" id="cerrar_caso" name="cerrar_caso">
                    <label for="cerrar_caso">
                        Marcar este caso como <strong>CERRADO</strong> después de enviar la respuesta
                    </label>
                </div>
                
                <div class="form-actions">
                    <a href="/casos/detalle/<?php echo $caso_id; ?>" class="btn btn-secondary">Cancelar</a>
                    <button type="submit" class="btn btn-primary">Enviar Respuesta</button>
                </div>
            </form>
        </div>
    </div>
</body>
</html>
