<?php
/**
 * Listado de Casos
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_id = $_SESSION['usuario_id'];
$usuario_nombre = $_SESSION['usuario_nombre'];
$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

// Filtros
$filtro_estado = $_GET['estado'] ?? '';
$filtro_tipo = $_GET['tipo'] ?? '';
$filtro_prioridad = $_GET['prioridad'] ?? '';
$filtro_busqueda = $_GET['busqueda'] ?? '';
$pagina = intval($_GET['pagina'] ?? 1);
$por_pagina = 20;
$offset = ($pagina - 1) * $por_pagina;

// Construir WHERE
$where_conditions = ['1=1'];
$params = [];
$types = '';

// Filtro por empresa (según rol)
if ($usuario_rol !== 'superadmin' && $empresa_id) {
    $where_conditions[] = 'c.empresa_id = ?';
    $params[] = $empresa_id;
    $types .= 'i';
}

// Filtro por estado
if (!empty($filtro_estado)) {
    $where_conditions[] = 'c.estado = ?';
    $params[] = $filtro_estado;
    $types .= 's';
}

// Filtro por tipo
if (!empty($filtro_tipo)) {
    $where_conditions[] = 'c.tipo_caso = ?';
    $params[] = $filtro_tipo;
    $types .= 's';
}

// Filtro por prioridad
if (!empty($filtro_prioridad)) {
    $where_conditions[] = 'c.prioridad = ?';
    $params[] = $filtro_prioridad;
    $types .= 's';
}

// Búsqueda
if (!empty($filtro_busqueda)) {
    $where_conditions[] = '(c.numero_caso LIKE ? OR c.asunto LIKE ? OR cl.nombre LIKE ? OR cl.rut LIKE ?)';
    $busqueda_param = '%' . $filtro_busqueda . '%';
    $params[] = $busqueda_param;
    $params[] = $busqueda_param;
    $params[] = $busqueda_param;
    $params[] = $busqueda_param;
    $types .= 'ssss';
}

$where_sql = implode(' AND ', $where_conditions);

// Contar total
$query_count = "SELECT COUNT(*) as total FROM casos c 
                JOIN clientes cl ON c.cliente_id = cl.id 
                WHERE $where_sql";
$result_count = obtener_fila($query_count, $types, $params);
$total_casos = $result_count['total'] ?? 0;
$total_paginas = ceil($total_casos / $por_pagina);

// Obtener casos
$query = "SELECT c.id, c.numero_caso, c.tipo_caso, c.asunto, c.estado, c.prioridad, 
          c.fecha_creacion, cl.nombre as cliente_nombre, cl.rut as cliente_rut,
          e.siglas as empresa_siglas, e.nombre as empresa_nombre,
          u.nombre as creador_nombre
          FROM casos c
          JOIN clientes cl ON c.cliente_id = cl.id
          JOIN empresas e ON c.empresa_id = e.id
          LEFT JOIN usuarios u ON c.usuario_creador_id = u.id
          WHERE $where_sql
          ORDER BY c.fecha_creacion DESC
          LIMIT ? OFFSET ?";

$params_paginado = array_merge($params, [$por_pagina, $offset]);
$types_paginado = $types . 'ii';

$casos = obtener_filas($query, $types_paginado, $params_paginado);

// Obtener empresa del usuario
$empresa_nombre = 'Todas las empresas';
if ($empresa_id) {
    $query_empresa = "SELECT nombre FROM empresas WHERE id = ?";
    $empresa_data = obtener_fila($query_empresa, 'i', [$empresa_id]);
    $empresa_nombre = $empresa_data['nombre'] ?? 'N/A';
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Casos - <?php echo APP_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: #f5f7fa; color: #333; }
        .navbar { background: white; border-bottom: 1px solid #e1e4e8; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        .navbar-brand { font-size: 18px; font-weight: 600; color: #333; text-decoration: none; }
        .navbar-user { display: flex; align-items: center; gap: 20px; }
        .navbar-user span { font-size: 14px; color: #666; }
        .btn-logout { padding: 8px 16px; background: #dc3545; color: white; text-decoration: none; border-radius: 4px; font-size: 14px; }
        .container { max-width: 1400px; margin: 30px auto; padding: 0 30px; }
        .page-header { margin-bottom: 30px; display: flex; justify-content: space-between; align-items: center; }
        .page-header h1 { font-size: 28px; }
        .btn { padding: 10px 20px; border-radius: 6px; text-decoration: none; font-size: 14px; font-weight: 500; border: none; cursor: pointer; transition: all 0.3s; }
        .btn-primary { background: #667eea; color: white; }
        .btn-primary:hover { background: #5568d3; }
        .btn-secondary { background: #6c757d; color: white; }
        .card { background: white; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); padding: 25px; margin-bottom: 20px; }
        .filters { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 15px; margin-bottom: 20px; }
        .filter-group label { display: block; margin-bottom: 5px; font-size: 13px; font-weight: 500; color: #666; }
        .filter-group select, .filter-group input { width: 100%; padding: 8px 12px; border: 1px solid #ddd; border-radius: 4px; font-size: 14px; }
        .filter-actions { display: flex; gap: 10px; align-items: flex-end; }
        .stats-row { display: flex; gap: 15px; margin-bottom: 20px; font-size: 14px; color: #666; }
        table { width: 100%; border-collapse: collapse; }
        table th { background: #f8f9fa; padding: 12px; text-align: left; font-size: 13px; font-weight: 600; color: #666; border-bottom: 2px solid #e1e4e8; }
        table td { padding: 12px; border-bottom: 1px solid #e1e4e8; font-size: 14px; }
        table tr:hover { background: #f8f9fa; cursor: pointer; }
        .badge { display: inline-block; padding: 4px 10px; border-radius: 12px; font-size: 12px; font-weight: 500; }
        .badge-nuevo { background: #e3f2fd; color: #1976d2; }
        .badge-visto { background: #f3e5f5; color: #7b1fa2; }
        .badge-asignado { background: #fff3e0; color: #f57c00; }
        .badge-en_proceso { background: #e8f5e9; color: #388e3c; }
        .badge-respondido { background: #e0f2f1; color: #00796b; }
        .badge-cerrado { background: #e0e0e0; color: #616161; }
        .badge-urgente { background: #ffebee; color: #c62828; }
        .badge-alta { background: #fff3e0; color: #ef6c00; }
        .badge-media { background: #fff9c4; color: #f9a825; }
        .badge-baja { background: #e8f5e9; color: #43a047; }
        .pagination { display: flex; justify-content: center; gap: 5px; margin-top: 20px; }
        .pagination a, .pagination span { padding: 8px 12px; border: 1px solid #ddd; border-radius: 4px; text-decoration: none; color: #333; }
        .pagination .active { background: #667eea; color: white; border-color: #667eea; }
        .pagination a:hover { background: #f8f9fa; }
        .empty-state { text-align: center; padding: 60px 20px; color: #999; }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="/dashboard" class="navbar-brand"><?php echo APP_NAME; ?></a>
        <div class="navbar-user">
            <a href="/dashboard" style="color: #666; text-decoration: none; font-size: 14px;">← Volver al Dashboard</a>
            <span><strong><?php echo htmlspecialchars($usuario_nombre); ?></strong> (<?php echo ROLES[$usuario_rol]; ?>)</span>
            <a href="/logout" class="btn-logout">Cerrar Sesión</a>
        </div>
    </nav>
    
    <div class="container">
        <div class="page-header">
            <div>
                <h1>Gestión de Casos</h1>
                <p style="color: #666; font-size: 14px; margin-top: 5px;"><?php echo htmlspecialchars($empresa_nombre); ?></p>
            </div>
            <a href="/casos/crear" class="btn btn-primary">+ Nuevo Caso</a>
        </div>
        
        <div class="card">
            <form method="GET" action="/casos">
                <div class="filters">
                    <div class="filter-group">
                        <label>Buscar</label>
                        <input type="text" name="busqueda" placeholder="N° caso, asunto, cliente..." 
                               value="<?php echo htmlspecialchars($filtro_busqueda); ?>">
                    </div>
                    
                    <div class="filter-group">
                        <label>Estado</label>
                        <select name="estado">
                            <option value="">Todos</option>
                            <?php foreach (ESTADOS_CASO as $key => $label): ?>
                                <option value="<?php echo $key; ?>" <?php echo ($filtro_estado === $key) ? 'selected' : ''; ?>>
                                    <?php echo $label; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="filter-group">
                        <label>Tipo</label>
                        <select name="tipo">
                            <option value="">Todos</option>
                            <option value="reclamo" <?php echo ($filtro_tipo === 'reclamo') ? 'selected' : ''; ?>>Reclamo</option>
                            <option value="consulta" <?php echo ($filtro_tipo === 'consulta') ? 'selected' : ''; ?>>Consulta</option>
                            <option value="sugerencia" <?php echo ($filtro_tipo === 'sugerencia') ? 'selected' : ''; ?>>Sugerencia</option>
                            <option value="felicitacion" <?php echo ($filtro_tipo === 'felicitacion') ? 'selected' : ''; ?>>Felicitación</option>
                        </select>
                    </div>
                    
                    <div class="filter-group">
                        <label>Prioridad</label>
                        <select name="prioridad">
                            <option value="">Todas</option>
                            <?php foreach (PRIORIDADES_CASO as $key => $label): ?>
                                <option value="<?php echo $key; ?>" <?php echo ($filtro_prioridad === $key) ? 'selected' : ''; ?>>
                                    <?php echo $label; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="filter-actions">
                        <button type="submit" class="btn btn-primary">Filtrar</button>
                        <a href="/casos" class="btn btn-secondary">Limpiar</a>
                    </div>
                </div>
            </form>
            
            <div class="stats-row">
                <strong>Total de casos:</strong> <?php echo number_format($total_casos); ?> |
                <strong>Página:</strong> <?php echo $pagina; ?> de <?php echo max(1, $total_paginas); ?>
            </div>
            
            <?php if (empty($casos)): ?>
                <div class="empty-state">
                    <p>No se encontraron casos con los filtros aplicados</p>
                    <a href="/casos/crear" class="btn btn-primary" style="margin-top: 20px; display: inline-block;">Crear Primer Caso</a>
                </div>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>N° Caso</th>
                            <th>Tipo</th>
                            <th>Asunto</th>
                            <th>Cliente</th>
                            <th>Estado</th>
                            <th>Prioridad</th>
                            <th>Fecha</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($casos as $caso): ?>
                            <tr onclick="window.location='/casos/detalle/<?php echo $caso['id']; ?>'">
                                <td><strong><?php echo htmlspecialchars($caso['numero_caso']); ?></strong></td>
                                <td><?php echo ucfirst($caso['tipo_caso']); ?></td>
                                <td><?php echo htmlspecialchars(substr($caso['asunto'], 0, 50)) . (strlen($caso['asunto']) > 50 ? '...' : ''); ?></td>
                                <td><?php echo htmlspecialchars($caso['cliente_nombre']); ?></td>
                                <td><span class="badge badge-<?php echo $caso['estado']; ?>"><?php echo ESTADOS_CASO[$caso['estado']]; ?></span></td>
                                <td><span class="badge badge-<?php echo $caso['prioridad']; ?>"><?php echo PRIORIDADES_CASO[$caso['prioridad']]; ?></span></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($caso['fecha_creacion'])); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
                
                <?php if ($total_paginas > 1): ?>
                    <div class="pagination">
                        <?php if ($pagina > 1): ?>
                            <a href="/casos?pagina=<?php echo $pagina - 1; ?>&estado=<?php echo $filtro_estado; ?>&tipo=<?php echo $filtro_tipo; ?>&prioridad=<?php echo $filtro_prioridad; ?>&busqueda=<?php echo $filtro_busqueda; ?>">← Anterior</a>
                        <?php endif; ?>
                        
                        <?php for ($i = max(1, $pagina - 2); $i <= min($total_paginas, $pagina + 2); $i++): ?>
                            <?php if ($i == $pagina): ?>
                                <span class="active"><?php echo $i; ?></span>
                            <?php else: ?>
                                <a href="/casos?pagina=<?php echo $i; ?>&estado=<?php echo $filtro_estado; ?>&tipo=<?php echo $filtro_tipo; ?>&prioridad=<?php echo $filtro_prioridad; ?>&busqueda=<?php echo $filtro_busqueda; ?>"><?php echo $i; ?></a>
                            <?php endif; ?>
                        <?php endfor; ?>
                        
                        <?php if ($pagina < $total_paginas): ?>
                            <a href="/casos?pagina=<?php echo $pagina + 1; ?>&estado=<?php echo $filtro_estado; ?>&tipo=<?php echo $filtro_tipo; ?>&prioridad=<?php echo $filtro_prioridad; ?>&busqueda=<?php echo $filtro_busqueda; ?>">Siguiente →</a>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
