<?php
$flash = get_flash();
/**
 * Detalle de Caso
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

if (!verificar_sesion()) {
    redireccionar('/login');
}

$usuario_id = $_SESSION['usuario_id'];
$usuario_nombre = $_SESSION['usuario_nombre'];
$usuario_rol = $_SESSION['usuario_rol'];
$empresa_id = $_SESSION['empresa_id'];

$caso_id = intval($_GET['id'] ?? 0);

if (!$caso_id) {
    redireccionar('/casos');
}

// Obtener caso
$query = "SELECT c.*, 
          cl.nombre as cliente_nombre, cl.rut as cliente_rut, cl.email as cliente_email, cl.telefono as cliente_telefono,
          e.nombre as empresa_nombre, e.siglas as empresa_siglas,
          u_creador.nombre as creador_nombre,
          u_vio.nombre as vio_primero_nombre,
          arr.numero_arranque, arr.direccion as arranque_direccion
          FROM casos c
          JOIN clientes cl ON c.cliente_id = cl.id
          JOIN empresas e ON c.empresa_id = e.id
          LEFT JOIN usuarios u_creador ON c.usuario_creador_id = u_creador.id
          LEFT JOIN usuarios u_vio ON c.usuario_vio_primero_id = u_vio.id
          LEFT JOIN arranques arr ON c.arranque_id = arr.id
          WHERE c.id = ?";

$caso = obtener_fila($query, 'i', [$caso_id]);

if (!$caso) {
    redireccionar('/casos');
}

// Verificar acceso
if ($usuario_rol !== 'superadmin' && $caso['empresa_id'] != $empresa_id) {
    redireccionar('/casos');
}

// Registrar visualización
$query_viz = "INSERT INTO visualizaciones (caso_id, usuario_id, fecha_primera_vista, total_vistas) 
              VALUES (?, ?, NOW(), 1) 
              ON DUPLICATE KEY UPDATE total_vistas = total_vistas + 1, fecha_ultima_vista = NOW()";
ejecutar_query($query_viz, 'ii', [$caso_id, $usuario_id]);

// Marcar como "visto" si está "nuevo"
if ($caso['estado'] === 'nuevo') {
    $query_update = "UPDATE casos SET estado = 'visto', fecha_visto_primera_vez = NOW(), usuario_vio_primero_id = ? WHERE id = ?";
    ejecutar_query($query_update, 'ii', [$usuario_id, $caso_id]);
    registrar_historial($caso_id, $usuario_id, 'Estado cambiado', 'De nuevo a visto');
    $caso['estado'] = 'visto';
}

// Obtener respuestas
$query_respuestas = "SELECT r.*, u.nombre as usuario_nombre, u_aprobador.nombre as aprobador_nombre
                     FROM respuestas r
                     JOIN usuarios u ON r.usuario_id = u.id
                     LEFT JOIN usuarios u_aprobador ON r.aprobado_por_id = u_aprobador.id
                     WHERE r.caso_id = ?
                     ORDER BY r.fecha_respuesta DESC";
$respuestas = obtener_filas($query_respuestas, 'i', [$caso_id]);

// Obtener historial
$query_historial = "SELECT h.*, u.nombre as usuario_nombre
                    FROM historial_casos h
                    JOIN usuarios u ON h.usuario_id = u.id
                    WHERE h.caso_id = ?
                    ORDER BY h.fecha_accion DESC
                    LIMIT 50";
$historial = obtener_filas($query_historial, 'i', [$caso_id]);

// Procesar cambio de estado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cambiar_estado'])) {
    $nuevo_estado = limpiar_entrada($_POST['nuevo_estado'] ?? '');
    $csrf_token = $_POST['csrf_token'] ?? '';
    
    if (verificar_csrf_token($csrf_token) && !empty($nuevo_estado)) {
        $query_cambio = "UPDATE casos SET estado = ? WHERE id = ?";
        ejecutar_query($query_cambio, 'si', [$nuevo_estado, $caso_id]);
        
        if ($nuevo_estado === 'cerrado') {
            $query_cierre = "UPDATE casos SET fecha_cierre = NOW() WHERE id = ?";
            ejecutar_query($query_cierre, 'i', [$caso_id]);
        }
        
        registrar_historial($caso_id, $usuario_id, 'Estado cambiado', "Estado cambiado a: " . ESTADOS_CASO[$nuevo_estado]);
        
        redireccionar('/casos/detalle/' . $caso_id);
    }
}

// Procesar cambio de prioridad
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cambiar_prioridad'])) {
    $nueva_prioridad = limpiar_entrada($_POST['nueva_prioridad'] ?? '');
    $csrf_token = $_POST['csrf_token'] ?? '';
    
    if (verificar_csrf_token($csrf_token) && !empty($nueva_prioridad)) {
        $query_prioridad = "UPDATE casos SET prioridad = ? WHERE id = ?";
        ejecutar_query($query_prioridad, 'si', [$nueva_prioridad, $caso_id]);
        
        registrar_historial($caso_id, $usuario_id, 'Prioridad cambiada', "Prioridad cambiada a: " . PRIORIDADES_CASO[$nueva_prioridad]);
        
        redireccionar('/casos/detalle/' . $caso_id);
    }
}

$csrf_token = generar_csrf_token();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Caso <?php echo htmlspecialchars($caso['numero_caso']); ?> - <?php echo APP_NAME; ?></title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: #f5f7fa; color: #333; }
        .navbar { background: white; border-bottom: 1px solid #e1e4e8; padding: 15px 30px; display: flex; justify-content: space-between; align-items: center; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        .navbar-brand { font-size: 18px; font-weight: 600; color: #333; text-decoration: none; }
        .navbar-user { display: flex; align-items: center; gap: 20px; }
        .btn-logout { padding: 8px 16px; background: #dc3545; color: white; text-decoration: none; border-radius: 4px; font-size: 14px; }
        .container { max-width: 1400px; margin: 30px auto; padding: 0 30px; }
        .page-header { margin-bottom: 30px; }
        .page-header h1 { font-size: 28px; margin-bottom: 10px; }
        .back-link { color: #667eea; text-decoration: none; font-size: 14px; }
        .back-link:hover { text-decoration: underline; }
        .grid-layout { display: grid; grid-template-columns: 2fr 1fr; gap: 20px; }
        .card { background: white; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); padding: 25px; margin-bottom: 20px; }
        .card h2 { font-size: 18px; margin-bottom: 20px; padding-bottom: 10px; border-bottom: 2px solid #f0f0f0; }
        .badge { display: inline-block; padding: 6px 12px; border-radius: 12px; font-size: 13px; font-weight: 500; }
        .badge-nuevo { background: #e3f2fd; color: #1976d2; }
        .badge-visto { background: #f3e5f5; color: #7b1fa2; }
        .badge-asignado { background: #fff3e0; color: #f57c00; }
        .badge-en_proceso { background: #e8f5e9; color: #388e3c; }
        .badge-respondido { background: #e0f2f1; color: #00796b; }
        .badge-cerrado { background: #e0e0e0; color: #616161; }
        .badge-urgente { background: #ffebee; color: #c62828; }
        .badge-alta { background: #fff3e0; color: #ef6c00; }
        .badge-media { background: #fff9c4; color: #f9a825; }
        .badge-baja { background: #e8f5e9; color: #43a047; }
        .info-row { display: flex; justify-content: space-between; padding: 12px 0; border-bottom: 1px solid #f0f0f0; }
        .info-row:last-child { border-bottom: none; }
        .info-label { font-weight: 500; color: #666; }
        .info-value { color: #333; }
        .descripcion-box { background: #f8f9fa; padding: 15px; border-radius: 6px; margin-top: 15px; line-height: 1.6; }
        .btn { padding: 10px 20px; border-radius: 6px; text-decoration: none; font-size: 14px; font-weight: 500; border: none; cursor: pointer; transition: all 0.3s; display: inline-block; }
        .btn-primary { background: #667eea; color: white; }
        .btn-primary:hover { background: #5568d3; }
        .btn-success { background: #28a745; color: white; }
        .btn-success:hover { background: #218838; }
        .btn-warning { background: #ffc107; color: #333; }
        .btn-danger { background: #dc3545; color: white; }
        .btn-block { display: block; width: 100%; text-align: center; margin-bottom: 10px; }
        .actions-grid { display: grid; gap: 10px; }
        .historial-item { padding: 12px; background: #f8f9fa; border-radius: 6px; margin-bottom: 10px; font-size: 13px; }
        .historial-item strong { color: #667eea; }
        .historial-item .fecha { color: #999; font-size: 12px; }
        .respuesta-item { padding: 15px; background: #f8f9fa; border-radius: 6px; margin-bottom: 15px; border-left: 4px solid #667eea; }
        .respuesta-header { display: flex; justify-content: space-between; margin-bottom: 10px; }
        .respuesta-contenido { line-height: 1.6; }
        select { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 6px; margin-bottom: 10px; }
    </style>
</head>
<body>
    <nav class="navbar">
        <a href="/dashboard" class="navbar-brand"><?php echo APP_NAME; ?></a>
        <div class="navbar-user">
            <span><strong><?php echo htmlspecialchars($usuario_nombre); ?></strong> (<?php echo ROLES[$usuario_rol]; ?>)</span>
            <a href="/logout" class="btn-logout">Cerrar Sesión</a>
        </div>
    </nav>
    
    <div class="container">
        <?php if ($flash): ?>
    <div class="alert alert-<?php echo $flash['tipo']; ?>" style="margin-bottom:20px;padding:14px 22px;border-radius:6px;font-size:15px;">
        <?php echo htmlspecialchars($flash['mensaje']); ?>
    </div>
<?php endif; ?>

        <div class="page-header">
            <a href="/casos" class="back-link">← Volver a Gestión de Casos</a>
            <h1>Caso <?php echo htmlspecialchars($caso['numero_caso']); ?></h1>
        </div>
        
        <div class="grid-layout">
            <!-- Columna principal -->
            <div>
                <!-- Información del caso -->
                <div class="card">
                    <h2>Información del Caso</h2>
                    
                    <div class="info-row">
                        <span class="info-label">Número de Caso:</span>
                        <span class="info-value"><strong><?php echo htmlspecialchars($caso['numero_caso']); ?></strong></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Tipo:</span>
                        <span class="info-value"><?php echo ucfirst($caso['tipo_caso']); ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Estado:</span>
                        <span class="info-value">
                            <span class="badge badge-<?php echo $caso['estado']; ?>">
                                <?php echo ESTADOS_CASO[$caso['estado']]; ?>
                            </span>
                        </span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Prioridad:</span>
                        <span class="info-value">
                            <span class="badge badge-<?php echo $caso['prioridad']; ?>">
                                <?php echo PRIORIDADES_CASO[$caso['prioridad']]; ?>
                            </span>
                        </span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Empresa:</span>
                        <span class="info-value"><?php echo htmlspecialchars($caso['empresa_nombre']); ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Fecha Creación:</span>
                        <span class="info-value"><?php echo date('d/m/Y H:i', strtotime($caso['fecha_creacion'])); ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Creado por:</span>
                        <span class="info-value"><?php echo htmlspecialchars($caso['creador_nombre'] ?? 'Sistema'); ?></span>
                    </div>
                    
                    <h3 style="margin-top: 20px; margin-bottom: 10px;">Asunto</h3>
                    <p><?php echo htmlspecialchars($caso['asunto']); ?></p>
                    
                    <h3 style="margin-top: 20px; margin-bottom: 10px;">Descripción</h3>
                    <div class="descripcion-box">
                        <?php echo nl2br(htmlspecialchars($caso['descripcion'])); ?>
                    </div>
                </div>
                
                <!-- Información del cliente -->
                <div class="card">
                    <h2>Información del Cliente</h2>
                    
                    <div class="info-row">
                        <span class="info-label">Nombre:</span>
                        <span class="info-value"><?php echo htmlspecialchars($caso['cliente_nombre']); ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">RUT:</span>
                        <span class="info-value"><?php echo htmlspecialchars($caso['cliente_rut']); ?></span>
                    </div>
                    
                    <?php if ($caso['cliente_email']): ?>
                    <div class="info-row">
                        <span class="info-label">Email:</span>
                        <span class="info-value"><?php echo htmlspecialchars($caso['cliente_email']); ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($caso['cliente_telefono']): ?>
                    <div class="info-row">
                        <span class="info-label">Teléfono:</span>
                        <span class="info-value"><?php echo htmlspecialchars($caso['cliente_telefono']); ?></span>
                    </div>
                    <?php endif; ?>
                    
                    <?php if ($caso['numero_arranque']): ?>
                    <div class="info-row">
                        <span class="info-label">N° Arranque:</span>
                        <span class="info-value"><?php echo htmlspecialchars($caso['numero_arranque']); ?></span>
                    </div>
                    
                    <div class="info-row">
                        <span class="info-label">Dirección:</span>
                        <span class="info-value"><?php echo htmlspecialchars($caso['arranque_direccion']); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- Respuestas -->
                <?php if (!empty($respuestas)): ?>
                <div class="card">
                    <h2>Respuestas (<?php echo count($respuestas); ?>)</h2>
                    
                    <?php foreach ($respuestas as $resp): ?>
                        <div class="respuesta-item">
                            <div class="respuesta-header">
                                <strong><?php echo htmlspecialchars($resp['usuario_nombre']); ?></strong>
                                <span class="badge badge-<?php echo $resp['estado']; ?>"><?php echo ucfirst($resp['estado']); ?></span>
                            </div>
                            <div class="respuesta-contenido">
                                <?php echo nl2br(htmlspecialchars($resp['contenido_respuesta'])); ?>
                            </div>
                            <div class="fecha" style="margin-top: 10px;">
                                <?php echo date('d/m/Y H:i', strtotime($resp['fecha_respuesta'])); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
                
                <!-- Historial -->
                <div class="card">
                    <h2>Historial de Actividad</h2>
                    
                    <?php foreach ($historial as $h): ?>
                        <div class="historial-item">
                            <strong><?php echo htmlspecialchars($h['accion']); ?></strong>
                            <?php if ($h['descripcion']): ?>
                                - <?php echo htmlspecialchars($h['descripcion']); ?>
                            <?php endif; ?>
                            <div class="fecha">
                                <?php echo htmlspecialchars($h['usuario_nombre']); ?> • 
                                <?php echo date('d/m/Y H:i', strtotime($h['fecha_accion'])); ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <!-- Columna lateral -->
            <div>
                <!-- Acciones -->
                <div class="card">
                    <h2>Acciones</h2>
                    
                    <div class="actions-grid">
                        <?php if ($caso['estado'] !== 'cerrado'): ?>
                            <a href="/casos/responder/<?php echo $caso_id; ?>" class="btn btn-primary btn-block">
                                Responder Caso
                            </a>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Cambiar estado -->
                    <h3 style="margin-top: 20px; margin-bottom: 10px; font-size: 14px;">Cambiar Estado</h3>
                    <form method="POST">
                        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                        <select name="nuevo_estado">
                            <?php foreach (ESTADOS_CASO as $key => $label): ?>
                                <option value="<?php echo $key; ?>" <?php echo ($caso['estado'] === $key) ? 'selected' : ''; ?>>
                                    <?php echo $label; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <button type="submit" name="cambiar_estado" class="btn btn-primary btn-block">Actualizar Estado</button>
                    </form>
                    
                    <!-- Cambiar prioridad -->
                    <h3 style="margin-top: 20px; margin-bottom: 10px; font-size: 14px;">Cambiar Prioridad</h3>
                    <form method="POST">
                        <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                        <select name="nueva_prioridad">
                            <?php foreach (PRIORIDADES_CASO as $key => $label): ?>
                                <option value="<?php echo $key; ?>" <?php echo ($caso['prioridad'] === $key) ? 'selected' : ''; ?>>
                                    <?php echo $label; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <button type="submit" name="cambiar_prioridad" class="btn btn-warning btn-block">Actualizar Prioridad</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
