<?php
/**
 * Módulo de Login
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

// Si ya está logueado, redirigir a dashboard
if (verificar_sesion()) {
    redireccionar('/dashboard');
}

$error = '';
$mensaje = '';

// Procesar formulario de login
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = limpiar_entrada($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    $csrf_token = $_POST['csrf_token'] ?? '';
    
    // Verificar CSRF
    if (!verificar_csrf_token($csrf_token)) {
        $error = 'Token de seguridad inválido';
    } else {
        // Validar campos
        if (empty($email) || empty($password)) {
            $error = 'Debe ingresar email y contraseña';
        } else {
            // Buscar usuario
            $query = "SELECT id, nombre, email, password_hash, rol, empresa_id, activo 
                      FROM usuarios 
                      WHERE email = ? LIMIT 1";
            
            $usuario = obtener_fila($query, 's', [$email]);
            
            if (!$usuario) {
                $error = 'Credenciales incorrectas';
                registrar_log_seguridad('Login fallido: usuario no existe', null, ['email' => $email]);
            } elseif ($usuario['activo'] != 1) {
                $error = 'Usuario inactivo. Contacte al administrador';
                registrar_log_seguridad('Login fallido: usuario inactivo', $usuario['id'], ['email' => $email]);
            } elseif (!verificar_password($password, $usuario['password_hash'])) {
                $error = 'Credenciales incorrectas';
                registrar_log_seguridad('Login fallido: contraseña incorrecta', $usuario['id'], ['email' => $email]);
            } else {
                // Login exitoso
                $_SESSION['usuario_id'] = $usuario['id'];
                $_SESSION['usuario_nombre'] = $usuario['nombre'];
                $_SESSION['usuario_email'] = $usuario['email'];
                $_SESSION['usuario_rol'] = $usuario['rol'];
                $_SESSION['empresa_id'] = $usuario['empresa_id'];
                $_SESSION['ultima_actividad'] = time();
                
                // Actualizar fecha último acceso
                $query_update = "UPDATE usuarios SET fecha_ultimo_acceso = NOW() WHERE id = ?";
                ejecutar_query($query_update, 'i', [$usuario['id']]);
                
                registrar_log_seguridad('Login exitoso', $usuario['id'], ['email' => $email]);
                
                redireccionar('/dashboard');
            }
        }
    }
}

// Generar nuevo token CSRF
$csrf_token = generar_csrf_token();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - <?php echo APP_NAME; ?></title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .login-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            max-width: 420px;
            width: 100%;
            padding: 40px;
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .login-header h1 {
            font-size: 24px;
            color: #333;
            margin-bottom: 8px;
        }
        
        .login-header p {
            font-size: 14px;
            color: #666;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-size: 14px;
            font-weight: 500;
            color: #333;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px 15px;
            border: 1px solid #ddd;
            border-radius: 6px;
            font-size: 14px;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .btn-login {
            width: 100%;
            padding: 14px;
            background: #667eea;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .btn-login:hover {
            background: #5568d3;
        }
        
        .alert {
            padding: 12px 15px;
            border-radius: 6px;
            margin-bottom: 20px;
            font-size: 14px;
        }
        
        .alert-error {
            background: #fee;
            color: #c33;
            border: 1px solid #fcc;
        }
        
        .alert-success {
            background: #efe;
            color: #3c3;
            border: 1px solid #cfc;
        }
        
        .login-footer {
            margin-top: 30px;
            text-align: center;
            font-size: 12px;
            color: #999;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1><?php echo APP_NAME; ?></h1>
            <p>Ingrese sus credenciales</p>
        </div>
        
        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>
        
        <?php if ($mensaje): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($mensaje); ?></div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
            
            <div class="form-group">
                <label for="email">Correo Electrónico</label>
                <input type="email" id="email" name="email" required 
                       value="<?php echo htmlspecialchars($email ?? ''); ?>" 
                       autocomplete="email">
            </div>
            
            <div class="form-group">
                <label for="password">Contraseña</label>
                <input type="password" id="password" name="password" required autocomplete="current-password">
            </div>
            
            <button type="submit" class="btn-login">Iniciar Sesión</button>
        </form>
        
        <div class="login-footer">
            <?php echo APP_NAME; ?> v<?php echo APP_VERSION; ?>
        </div>
    </div>
</body>
</html>
