<?php
/**
 * Funciones Comunes
 * Versión: 2.0 Definitiva
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

/**
 * Formatear fecha en español
 */
function formatear_fecha($fecha, $incluir_hora = false) {
    if (empty($fecha)) return 'N/A';
    
    $timestamp = strtotime($fecha);
    if (!$timestamp) return 'N/A';
    
    $formato = $incluir_hora ? 'd/m/Y H:i' : 'd/m/Y';
    return date($formato, $timestamp);
}

/**
 * Formatear número con separadores
 */
function formatear_numero($numero, $decimales = 0) {
    if (!is_numeric($numero)) return '0';
    return number_format($numero, $decimales, ',', '.');
}

/**
 * Obtener iniciales de un nombre
 */
function obtener_iniciales($nombre) {
    $palabras = explode(' ', trim($nombre));
    $iniciales = '';
    
    foreach ($palabras as $palabra) {
        if (!empty($palabra)) {
            $iniciales .= strtoupper(substr($palabra, 0, 1));
        }
    }
    
    return substr($iniciales, 0, 2);
}

/**
 * Generar número de caso
 */
function generar_numero_caso($empresa_id, $tipo_caso) {
    $db = obtener_conexion();
    if (!$db) return false;
    
    $query_empresa = "SELECT siglas FROM empresas WHERE id = ?";
    $empresa = obtener_fila($query_empresa, 'i', [$empresa_id]);
    if (!$empresa) return false;
    
    $query_tipo = "SELECT sigla FROM tipos_caso_siglas WHERE tipo_caso = ?";
    $tipo = obtener_fila($query_tipo, 's', [$tipo_caso]);
    if (!$tipo) return false;
    
    $sigla_empresa = $empresa['siglas'];
    $sigla_tipo = $tipo['sigla'];
    
    $db->begin_transaction();
    
    try {
        $query = "SELECT ultimo_numero FROM contador_casos 
                  WHERE empresa_id = ? AND tipo_caso = ? FOR UPDATE";
        $contador = obtener_fila($query, 'is', [$empresa_id, $sigla_tipo]);
        
        if (!$contador) {
            $query_insert = "INSERT INTO contador_casos (empresa_id, tipo_caso, ultimo_numero) 
                            VALUES (?, ?, 1)";
            insertar($query_insert, 'is', [$empresa_id, $sigla_tipo]);
            $numero = 1;
        } else {
            $numero = $contador['ultimo_numero'] + 1;
            $query_update = "UPDATE contador_casos SET ultimo_numero = ? 
                            WHERE empresa_id = ? AND tipo_caso = ?";
            ejecutar_query($query_update, 'iis', [$numero, $empresa_id, $sigla_tipo]);
        }
        
        $db->commit();
        
        return sprintf('%s-%s-%05d', $sigla_empresa, $sigla_tipo, $numero);
        
    } catch (Exception $e) {
        $db->rollback();
        error_log("Error generando número de caso: " . $e->getMessage());
        return false;
    }
}

/**
 * Registrar en historial
 */
function registrar_historial($caso_id, $usuario_id, $accion, $descripcion = '', $cambios_previos = [], $cambios_nuevos = []) {
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    
    $query = "INSERT INTO historial_casos (caso_id, usuario_id, accion, descripcion, cambios_previos, cambios_nuevos, ip_usuario) 
              VALUES (?, ?, ?, ?, ?, ?, ?)";
    
    $cambios_previos_json = json_encode($cambios_previos);
    $cambios_nuevos_json = json_encode($cambios_nuevos);
    
    insertar($query, 'iisssss', [
        $caso_id,
        $usuario_id,
        $accion,
        $descripcion,
        $cambios_previos_json,
        $cambios_nuevos_json,
        $ip
    ]);
}
/**
 * Enviar email simple usando mail()
 * @param string $destinatario
 * @param string $asunto
 * @param string $mensaje_html
 * @return bool
 */
function enviar_email($destinatario, $asunto, $mensaje_html) {
    $headers = "From: " . EMAIL_FROM_NAME . " <" . EMAIL_FROM . ">\r\n";
    $headers .= "Content-type: text/html; charset=UTF-8\r\n";

    return mail($destinatario, $asunto, $mensaje_html, $headers);
}
