<?php
/**
 * Router Principal
 * Versión: 2.0 Definitiva
 */

define('COMITEH_APP', true);

// Cargar configuración
require_once __DIR__ . '/config/configuracion.php';
require_once __DIR__ . '/config/conexion.php';
require_once __DIR__ . '/config/seguridad.php';
require_once __DIR__ . '/lib/funciones_comunes.php';

// Iniciar sesión
iniciar_sesion();

// Obtener ruta solicitada
$request_uri = $_SERVER['REQUEST_URI'];
$script_name = $_SERVER['SCRIPT_NAME'];
$base_path = str_replace('/index.php', '', $script_name);
$ruta = str_replace($base_path, '', $request_uri);
$ruta = strtok($ruta, '?');
$ruta = trim($ruta, '/');

// Si no hay ruta, redirigir a login o dashboard
if (empty($ruta)) {
    if (verificar_sesion()) {
        $ruta = 'dashboard';
    } else {
        $ruta = 'login';
    }
}

// Parsear ruta
$partes = explode('/', $ruta);
$modulo = $partes[0] ?? 'login';
$accion = $partes[1] ?? 'index';
$parametro = $partes[2] ?? null;

// Rutas públicas (sin autenticación)
$rutas_publicas = ['login', 'logout', 'test'];

// Verificar autenticación
if (!in_array($modulo, $rutas_publicas) && !verificar_sesion()) {
    redireccionar('/login');
}

// Enrutamiento
switch ($modulo) {
    case 'test':
        echo json_encode([
            'status' => 'ok',
            'version' => APP_VERSION,
            'timestamp' => date('Y-m-d H:i:s')
        ]);
        break;
        
    case 'login':
        require_once MODULES_PATH . '/auth/login.php';
        break;
        
    case 'logout':
        require_once MODULES_PATH . '/auth/logout.php';
        break;
        
    case 'dashboard':
        require_once MODULES_PATH . '/dashboard/dashboard.php';
        break;
        
    case 'casos':
        if ($accion === 'crear') {
            require_once MODULES_PATH . '/casos/crear_caso.php';
        } elseif ($accion === 'detalle' && $parametro) {
            $_GET['id'] = $parametro;
            require_once MODULES_PATH . '/casos/detalle_caso.php';
        } else {
            require_once MODULES_PATH . '/casos/listar_casos.php';
        }
        break;
        
    default:
        http_response_code(404);
        echo "404 - Página no encontrada";
        break;
}

// Cerrar conexión al final
cerrar_conexion();
