<?php
// Mostrar TODOS los errores
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo "<h1>Debug del Sistema</h1>";

// Test 1: Verificar archivos
echo "<h2>1. Verificación de archivos</h2>";
$archivos = [
    'index.php',
    'config/configuracion.php',
    'config/conexion.php',
    'config/seguridad.php',
    'lib/funciones_comunes.php',
    'modulos/auth/login.php',
    'modulos/auth/logout.php',
    'modulos/dashboard/dashboard.php'
];

foreach ($archivos as $archivo) {
    if (file_exists($archivo)) {
        $size = filesize($archivo);
        echo "✓ $archivo ($size bytes)<br>";
    } else {
        echo "✗ <span style='color:red'>$archivo - FALTA</span><br>";
    }
}

// Test 2: Intentar cargar config/configuracion.php
echo "<h2>2. Cargando configuración...</h2>";
define('COMITEH_APP', true);

try {
    require_once __DIR__ . '/config/configuracion.php';
    echo "✓ config/configuracion.php cargado correctamente<br>";
    echo "✓ APP_NAME: " . APP_NAME . "<br>";
    echo "✓ BASE_PATH: " . BASE_PATH . "<br>";
    echo "✓ PRIVATE_PATH: " . PRIVATE_PATH . "<br>";
    
    // Verificar que PRIVATE_PATH existe
    if (is_dir(PRIVATE_PATH)) {
        echo "✓ PRIVATE_PATH existe<br>";
    } else {
        echo "✗ <span style='color:red'>PRIVATE_PATH NO existe: " . PRIVATE_PATH . "</span><br>";
        echo "  └─ Intenta crear: mkdir -p " . PRIVATE_PATH . "<br>";
    }
    
    if (is_dir(LOGS_PATH)) {
        echo "✓ LOGS_PATH existe<br>";
    } else {
        echo "✗ <span style='color:red'>LOGS_PATH NO existe: " . LOGS_PATH . "</span><br>";
    }
    
    if (is_dir(UPLOADS_PATH)) {
        echo "✓ UPLOADS_PATH existe<br>";
    } else {
        echo "✗ <span style='color:red'>UPLOADS_PATH NO existe: " . UPLOADS_PATH . "</span><br>";
    }
    
} catch (Exception $e) {
    echo "✗ <span style='color:red'>ERROR: " . $e->getMessage() . "</span><br>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

// Test 3: Intentar cargar conexion.php
echo "<h2>3. Cargando conexión BD...</h2>";
try {
    require_once __DIR__ . '/config/conexion.php';
    echo "✓ config/conexion.php cargado correctamente<br>";
    
    $db = obtener_conexion();
    if ($db) {
        echo "✓ Conexión a BD exitosa<br>";
        echo "✓ Base de datos: " . DB_NAME . "<br>";
        cerrar_conexion();
    } else {
        echo "✗ <span style='
