<?php
/**
 * Configuración Global
 * Versión: 2.0 Definitiva
 * Dominio: contactabilidad.comite-ssr.cl
 */

if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

// Configuración de aplicación
define('APP_NAME', 'Portal de Contactabilidad SSR');
define('APP_VERSION', '2.0');
define('APP_URL', 'https://contactabilidad.comite-ssr.cl');
define('APP_TIMEZONE', 'America/Santiago');

// Rutas
define('BASE_PATH', dirname(__DIR__));
define('MODULES_PATH', BASE_PATH . '/modulos');
define('LIB_PATH', BASE_PATH . '/lib');
define('PRIVATE_PATH', dirname(BASE_PATH) . '/private');
define('UPLOADS_PATH', PRIVATE_PATH . '/documentos');
define('LOGS_PATH', PRIVATE_PATH . '/logs');

// Sesión
define('SESSION_NAME', 'COMITEH_SESSION');
define('SESSION_LIFETIME', 1800); // 30 minutos
define('SESSION_LIFETIME_CLIENT', 3600); // 60 minutos clientes

// Seguridad
define('CSRF_TOKEN_NAME', 'csrf_token');
define('PASSWORD_MIN_LENGTH', 8);
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOGIN_LOCKOUT_TIME', 900); // 15 minutos

// Archivos
define('MAX_FILE_SIZE', 5242880); // 5MB
define('ALLOWED_FILE_TYPES', ['pdf']);

// Email
define('EMAIL_FROM', 'noreply@comite-ssr.cl');
define('EMAIL_FROM_NAME', 'Portal Contactabilidad SSR');

// Paginación
define('ITEMS_PER_PAGE', 50);

// Estados de caso
define('ESTADOS_CASO', [
    'nuevo' => 'Nuevo',
    'visto' => 'Visto',
    'asignado' => 'Asignado',
    'en_proceso' => 'En Proceso',
    'pendiente_respuesta' => 'Pendiente Respuesta',
    'respondido' => 'Respondido',
    'pendiente_aprobacion' => 'Pendiente Aprobación',
    'cerrado' => 'Cerrado'
]);

// Prioridades
define('PRIORIDADES_CASO', [
    'baja' => 'Baja',
    'media' => 'Media',
    'alta' => 'Alta',
    'urgente' => 'Urgente'
]);

// Roles y permisos
define('ROLES', [
    'superadmin' => 'Super Administrador',
    'admin_empresa' => 'Administrador Empresa',
    'directorio' => 'Directorio',
    'ejecutivo' => 'Ejecutivo',
    'supervisor' => 'Supervisor',
    'cliente' => 'Cliente'
]);

// Configuración PHP
date_default_timezone_set(APP_TIMEZONE);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', LOGS_PATH . '/php_errors.log');

// Headers de seguridad
if (!headers_sent()) {
    header('X-Frame-Options: SAMEORIGIN');
    header('X-Content-Type-Options: nosniff');
    header('X-XSS-Protection: 1; mode=block');
    header('Referrer-Policy: strict-origin-when-cross-origin');
}
