<?php
/**
 * Conexión a Base de Datos MySQLi
 * Versión: 2.0 Definitiva
 */

// Prevenir acceso directo
if (!defined('COMITEH_APP')) {
    die('Acceso no autorizado');
}

// Configuración de base de datos
define('DB_HOST', 'localhost');
define('DB_USER', 'comiteh_reclamos');
define('DB_PASS', 'Redhat2025...');
define('DB_NAME', 'comiteh_reclamos');
define('DB_CHARSET', 'utf8mb4');

// Variable global de conexión
$GLOBALS['db'] = null;

/**
 * Obtener conexión MySQLi singleton
 * @return mysqli|null
 */
function obtener_conexion() {
    if ($GLOBALS['db'] !== null && $GLOBALS['db']->ping()) {
        return $GLOBALS['db'];
    }
    
    try {
        $mysqli = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        if ($mysqli->connect_error) {
            error_log("Error conexión BD: " . $mysqli->connect_error);
            return null;
        }
        
        $mysqli->set_charset(DB_CHARSET);
        $mysqli->query("SET time_zone = '-03:00'");
        
        $GLOBALS['db'] = $mysqli;
        return $mysqli;
        
    } catch (Exception $e) {
        error_log("Excepción conexión BD: " . $e->getMessage());
        return null;
    }
}

/**
 * Cerrar conexión
 */
function cerrar_conexion() {
    if ($GLOBALS['db'] !== null) {
        $GLOBALS['db']->close();
        $GLOBALS['db'] = null;
    }
}

/**
 * Ejecutar query con prepared statement
 * @param string $query
 * @param string $types
 * @param array $params
 * @return mysqli_result|bool
 */
function ejecutar_query($query, $types = '', $params = []) {
    $db = obtener_conexion();
    if (!$db) return false;
    
    $stmt = $db->prepare($query);
    if (!$stmt) {
        error_log("Error prepare: " . $db->error);
        return false;
    }
    
    if ($types && count($params) > 0) {
        $stmt->bind_param($types, ...$params);
    }
    
    $result = $stmt->execute();
    
    if (!$result) {
        error_log("Error execute: " . $stmt->error);
        $stmt->close();
        return false;
    }
    
    $data = $stmt->get_result();
    $stmt->close();
    
    return $data;
}

/**
 * Obtener un registro
 * @param string $query
 * @param string $types
 * @param array $params
 * @return array|null
 */
function obtener_fila($query, $types = '', $params = []) {
    $result = ejecutar_query($query, $types, $params);
    if (!$result) return null;
    return $result->fetch_assoc();
}

/**
 * Obtener múltiples registros
 * @param string $query
 * @param string $types
 * @param array $params
 * @return array
 */
function obtener_filas($query, $types = '', $params = []) {
    $result = ejecutar_query($query, $types, $params);
    if (!$result) return [];
    
    $rows = [];
    while ($row = $result->fetch_assoc()) {
        $rows[] = $row;
    }
    return $rows;
}

/**
 * Insertar y retornar ID
 * @param string $query
 * @param string $types
 * @param array $params
 * @return int|false
 */
function insertar($query, $types, $params) {
    $db = obtener_conexion();
    if (!$db) return false;
    
    $stmt = $db->prepare($query);
    if (!$stmt) return false;
    
    $stmt->bind_param($types, ...$params);
    $result = $stmt->execute();
    
    if (!$result) {
        $stmt->close();
        return false;
    }
    
    $id = $db->insert_id;
    $stmt->close();
    
    return $id;
}
