<?php
/**
 * Admin - Exportar Reclamos a Excel con Filtros
 * Versión: 1.1
 */

session_start();
// Verifica acceso admin aquí si es necesario

require_once __DIR__ . '/../config/conexion.php';

$is_excel = isset($_GET['export']) && $_GET['export'] == '1';

// --- Filtros desde formulario ---
$fecha_inicio = $_GET['fecha_inicio'] ?? '';
$fecha_fin = $_GET['fecha_fin'] ?? '';
$estado = $_GET['estado'] ?? '';
$empresa_id = $_GET['empresa_id'] ?? '';

// Construir WHERE
$where = [];
$params = [];
$types = '';

if ($fecha_inicio) {
    $where[] = "c.fecha_creacion >= ?";
    $params[] = $fecha_inicio;
    $types .= 's';
}
if ($fecha_fin) {
    $where[] = "c.fecha_creacion <= ?";
    $params[] = $fecha_fin . ' 23:59:59';
    $types .= 's';
}
if ($estado && $estado != 'todos') {
    $where[] = "c.estado = ?";
    $params[] = $estado;
    $types .= 's';
}
if ($empresa_id && $empresa_id != 'todas') {
    $where[] = "c.empresa_id = ?";
    $params[] = $empresa_id;
    $types .= 'i';
}

$where_sql = $where ? ('WHERE ' . implode(' AND ', $where)) : '';

// Listado para filtro empresa (puedes ajustar tabla/nombre)
$empresas = obtener_filas("SELECT id, nombre FROM empresas ORDER BY nombre");

// Exportar a Excel (CSV)
if ($is_excel) {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename="reclamos_' . date('Ymd_His') . '.csv"');

    $output = fopen('php://output', 'w');
    fputcsv($output, [
        'ID', 'Empresa', 'Cliente', 'Asunto', 'Descripción', 'Fecha Creación', 'Estado'
    ]);
    $query = "SELECT c.id, e.nombre as empresa, cl.nombre as cliente, c.asunto, c.descripcion, c.fecha_creacion, c.estado
              FROM casos c
              LEFT JOIN clientes cl ON c.cliente_id = cl.id
              LEFT JOIN empresas e ON c.empresa_id = e.id
              $where_sql
              ORDER BY c.fecha_creacion DESC
              LIMIT 2000";
    $stmt = $db->prepare($query);
    if ($types) $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        fputcsv($output, [
            $row['id'],
            $row['empresa'],
            $row['cliente'],
            $row['asunto'],
            strip_tags($row['descripcion']),
            $row['fecha_creacion'],
            $row['estado']
        ]);
    }
    fclose($output);
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8" />
<title>Exportar Reclamos - Admin</title>
<style>
body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, sans-serif; background: #f5f7fa; color: #333; }
.container { max-width: 600px; margin: 50px auto; background: #fff; border-radius: 8px; box-shadow: 0 3px 6px rgba(0,0,0,0.07); padding: 40px; }
h1 { text-align: center; margin-bottom: 30px; }
label { display: block; font-weight: 600; margin-bottom: 7px; }
input[type=date], select { width: 100%; padding: 8px 12px; border-radius: 6px; border: 1px solid #ccc; font-size: 14px; margin-bottom: 20px; }
button { padding: 12px 22px; background: #667eea; color: #fff; font-weight: 600; border: none; border-radius: 6px; font-size: 16px; cursor: pointer; }
button:hover { background: #5568d3; }
</style>
</head>
<body>
<div class="container">
    <h1>Exportar Reclamos</h1>
    <form method="GET" action="">
        <label for="empresa_id">Empresa</label>
        <select name="empresa_id" id="empresa_id">
            <option value="todas">Todas</option>
            <?php foreach ($empresas as $e): ?>
                <option value="<?php echo $e['id']; ?>" <?php echo ($empresa_id == $e['id']) ? 'selected' : ''; ?>><?php echo htmlspecialchars($e['nombre']); ?></option>
            <?php endforeach; ?>
        </select>

        <label for="estado">Estado</label>
        <select name="estado" id="estado">
            <option value="todos">Todos</option>
            <option value="nuevo" <?php echo ($estado == 'nuevo') ? 'selected' : ''; ?>>Nuevo</option>
            <option value="en_proceso" <?php echo ($estado == 'en_proceso') ? 'selected' : ''; ?>>En Proceso</option>
            <option value="resuelto" <?php echo ($estado == 'resuelto') ? 'selected' : ''; ?>>Resuelto</option>
            <option value="cerrado" <?php echo ($estado == 'cerrado') ? 'selected' : ''; ?>>Cerrado</option>
            <!-- Agrega otros estados según tu lógica -->
        </select>

        <label for="fecha_inicio">Fecha desde</label>
        <input type="date" name="fecha_inicio" id="fecha_inicio" value="<?php echo htmlspecialchars($fecha_inicio); ?>">

        <label for="fecha_fin">Fecha hasta</label>
        <input type="date" name="fecha_fin" id="fecha_fin" value="<?php echo htmlspecialchars($fecha_fin); ?>">

        <button type="submit" name="export" value="1">Exportar a Excel</button>
    </form>
</div>
</body>
</html>
